/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json.simplifier;

import java.util.Collection;
import java.util.Set;
import org.jolokia.converter.json.simplifier.AttributeExtractor;
import org.jolokia.converter.json.simplifier.SimplifierAccessor;
import org.jolokia.json.JSONArray;

public class ModuleSimplifier
extends SimplifierAccessor<Module> {
    public ModuleSimplifier() {
        super(Module.class);
        this.addExtractor("module", new NameAttributeExtractor());
        this.addExtractor("packages", new PackagesAttributeExtractor());
    }

    @Override
    public String extractString(Object pValue) {
        return ((Module)pValue).getName();
    }

    private static class NameAttributeExtractor
    implements AttributeExtractor<Module> {
        private NameAttributeExtractor() {
        }

        @Override
        public Object extract(Module mod) {
            return mod.getName();
        }
    }

    private static class PackagesAttributeExtractor
    implements AttributeExtractor<Module> {
        private PackagesAttributeExtractor() {
        }

        @Override
        public Object extract(Module mod) {
            Set<String> packages = mod.getPackages();
            if (packages == null || packages.isEmpty()) {
                return null;
            }
            return new JSONArray((Collection<?>)packages);
        }
    }
}

