/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json.simplifier;

import org.jolokia.converter.json.simplifier.AttributeExtractor;
import org.jolokia.converter.json.simplifier.SimplifierAccessor;
import org.w3c.dom.Element;

public class DomElementSimplifier
extends SimplifierAccessor<Element> {
    public DomElementSimplifier() {
        super(Element.class);
        this.addExtractor("name", new NameAttributeExtractor());
        this.addExtractor("namespace", new NamespaceAttributeExtractor());
        this.addExtractor("value", new ValueAttributeExtractor());
        this.addExtractor("hasChildNodes", new ChildAttributeExtractor());
    }

    @Override
    public String extractString(Object pValue) {
        Element el = (Element)pValue;
        String ns = el.getNamespaceURI();
        String localName = el.getNodeName();
        return ns == null || ns.isBlank() ? localName : "{" + ns + "}" + localName;
    }

    private static class NameAttributeExtractor
    implements AttributeExtractor<Element> {
        private NameAttributeExtractor() {
        }

        @Override
        public Object extract(Element element) {
            return element.getNodeName();
        }
    }

    private static class NamespaceAttributeExtractor
    implements AttributeExtractor<Element> {
        private NamespaceAttributeExtractor() {
        }

        @Override
        public Object extract(Element element) throws AttributeExtractor.SkipAttributeException {
            String ns = element.getNamespaceURI();
            if (ns == null) {
                throw new AttributeExtractor.SkipAttributeException();
            }
            return ns;
        }
    }

    private static class ValueAttributeExtractor
    implements AttributeExtractor<Element> {
        private ValueAttributeExtractor() {
        }

        @Override
        public Object extract(Element element) {
            return element.getNodeValue();
        }
    }

    private static class ChildAttributeExtractor
    implements AttributeExtractor<Element> {
        private ChildAttributeExtractor() {
        }

        @Override
        public Object extract(Element element) {
            return element.hasChildNodes();
        }
    }
}

