/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.json.ArrayAccessor;
import org.jolokia.converter.json.BeanAccessor;
import org.jolokia.converter.json.CalendarAccessor;
import org.jolokia.converter.json.CollectionAccessor;
import org.jolokia.converter.json.CompositeDataAccessor;
import org.jolokia.converter.json.DateAccessor;
import org.jolokia.converter.json.DateFormatConfiguration;
import org.jolokia.converter.json.EnumObjectAccessor;
import org.jolokia.converter.json.JavaTimeTemporalAccessor;
import org.jolokia.converter.json.ListAccessor;
import org.jolokia.converter.json.MapAccessor;
import org.jolokia.converter.json.ObjectAccessor;
import org.jolokia.converter.json.ObjectSerializationContext;
import org.jolokia.converter.json.SimpleAccessor;
import org.jolokia.converter.json.TabularDataAccessor;
import org.jolokia.converter.json.simplifier.SimplifierAccessor;
import org.jolokia.converter.object.Converter;
import org.jolokia.converter.object.ObjectToObjectConverter;
import org.jolokia.converter.object.ObjectToOpenTypeConverter;
import org.jolokia.core.config.CoreConfiguration;
import org.jolokia.core.service.serializer.SerializeOptions;
import org.jolokia.core.service.serializer.ValueFaultHandler;
import org.jolokia.core.util.EscapeUtil;
import org.jolokia.core.util.LocalServiceFactory;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;

public final class ObjectToJsonConverter {
    private static final String SIMPLIFIERS_DEFAULT_DEF = "META-INF/jolokia/simplifiers-default";
    private static final String SIMPLIFIERS_DEF = "META-INF/jolokia/simplifiers";
    private static final Deque<String> EMPTY_DEQUE = new LinkedList<String>();
    public static final Set<Class<?>> JSON_TYPES = Set.of(String.class, Boolean.TYPE, Boolean.class, Long.TYPE, Long.class, BigInteger.class, BigDecimal.class, JSONArray.class, JSONObject.class);
    public static final Set<Class<?>> JSON_BASIC_TYPES = Set.of(String.class, Boolean.TYPE, Boolean.class, Long.TYPE, Long.class, BigInteger.class, BigDecimal.class);
    public static final Map<Class<?>, String> JSON_CONVERSIONS = Map.ofEntries(Map.entry(Character.class, String.class.getName()), Map.entry(Character.TYPE, String.class.getName()), Map.entry(Float.class, BigDecimal.class.getName()), Map.entry(Float.TYPE, BigDecimal.class.getName()), Map.entry(Double.class, BigDecimal.class.getName()), Map.entry(Double.TYPE, BigDecimal.class.getName()), Map.entry(Byte.class, Long.class.getName()), Map.entry(Byte.TYPE, Long.class.getName()), Map.entry(Short.class, Long.class.getName()), Map.entry(Short.TYPE, Long.class.getName()), Map.entry(Integer.class, Long.class.getName()), Map.entry(Integer.TYPE, Long.class.getName()));
    private final ThreadLocal<ObjectSerializationContext> stackContextLocal = new ThreadLocal();
    private final List<ObjectAccessor> objectAccessors = new ArrayList<ObjectAccessor>();
    private final ArrayAccessor arrayAccessor;
    private final SimpleAccessor simpleAccessor;
    private final Converter<String> objectToObjectConverter;
    private final Map<Class<?>, ObjectAccessor> ACCESSORS_CACHE = Collections.synchronizedMap(new HashMap());

    public ObjectToJsonConverter(ObjectToObjectConverter pObjectToObjectConverter, ObjectToOpenTypeConverter pObjectToOpenTypeConverter, CoreConfiguration coreConfig) {
        this.objectAccessors.add(new TabularDataAccessor(pObjectToOpenTypeConverter));
        this.objectAccessors.add(new CompositeDataAccessor());
        this.objectAccessors.add(new MapAccessor());
        this.objectAccessors.add(new ListAccessor());
        this.objectAccessors.add(new CollectionAccessor());
        ArrayList simplifiers = new ArrayList();
        this.loadSimplifiers(simplifiers, coreConfig);
        this.objectAccessors.addAll(simplifiers);
        HashMap stringConverters = new HashMap();
        EnumObjectAccessor enumAccessor = new EnumObjectAccessor();
        this.objectAccessors.add(enumAccessor);
        stringConverters.put(enumAccessor.getType(), enumAccessor);
        DateFormatConfiguration dfc = new DateFormatConfiguration(coreConfig);
        DateAccessor dateAccessor = new DateAccessor(dfc);
        CalendarAccessor calendarAccessor = new CalendarAccessor(dfc);
        JavaTimeTemporalAccessor temporalAccessor = new JavaTimeTemporalAccessor(dfc);
        this.objectAccessors.add(dateAccessor);
        this.objectAccessors.add(calendarAccessor);
        this.objectAccessors.add(temporalAccessor);
        stringConverters.put(dateAccessor.getType(), dateAccessor);
        stringConverters.put(calendarAccessor.getType(), calendarAccessor);
        stringConverters.put(temporalAccessor.getType(), temporalAccessor);
        for (SimplifierAccessor simplifierAccessor : simplifiers) {
            if (!simplifierAccessor.supportsStringConversion()) continue;
            stringConverters.put(simplifierAccessor.getType(), simplifierAccessor);
        }
        this.simpleAccessor = new SimpleAccessor();
        this.objectAccessors.add(new BeanAccessor());
        this.arrayAccessor = new ArrayAccessor();
        if (pObjectToObjectConverter != null) {
            pObjectToObjectConverter.setStringConverters(stringConverters);
        }
        this.objectToObjectConverter = pObjectToObjectConverter;
    }

    public Object serialize(Object pValue, List<String> pPathParts, SerializeOptions pOptions) throws AttributeNotFoundException {
        LinkedList<String> extraStack = pPathParts != null ? EscapeUtil.reversePath(pPathParts) : new LinkedList<String>();
        return this.extractObjectWithContext(pValue, extraStack, pOptions, true);
    }

    public Object setInnerValue(Object pOuterObject, Object pNewValue, List<String> pPathParts) throws AttributeNotFoundException, IllegalAccessException, InvocationTargetException {
        String lastPathElement = pPathParts.remove(pPathParts.size() - 1);
        Deque<String> extraStack = EscapeUtil.reversePath(pPathParts);
        Object inner = this.extractObjectWithContext(pOuterObject, extraStack, SerializeOptions.DEFAULT, false);
        return this.setObjectValue(inner, lastPathElement, pNewValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractObject(Object pValue, Deque<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        Deque<String> pathStack;
        ObjectSerializationContext stackContext = this.stackContextLocal.get();
        String limitReached = this.checkForLimits(pValue, stackContext);
        Deque<String> deque = pathStack = pPathParts != null ? pPathParts : EMPTY_DEQUE;
        if (limitReached != null) {
            return limitReached;
        }
        try {
            if (pValue == null) {
                Object object = pathStack.isEmpty() ? null : stackContext.getValueFaultHandler().handleException(new AttributeNotFoundException("Cannot apply a path to a null value"));
                return object;
            }
            stackContext.push(pValue);
            Class<?> cls = pValue.getClass();
            if (cls.isArray()) {
                Object object = this.arrayAccessor.extractObject(this, pValue, pathStack, pJsonify);
                return object;
            }
            if (cls.isPrimitive() || JSON_BASIC_TYPES.contains(cls) || JSON_CONVERSIONS.containsKey(cls)) {
                if (!pathStack.isEmpty()) {
                    throw new ValueFaultHandler.AttributeFilteredException();
                }
                Object object = this.simpleAccessor.extractObject(this, pValue, null, pJsonify);
                return object;
            }
            Object object = this.invokeAccessor(pValue, pathStack, pJsonify);
            return object;
        }
        finally {
            stackContext.pop(pValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object extractObjectWithContext(Object pValue, Deque<String> pExtraArgs, SerializeOptions pOpts, boolean pJsonify) throws AttributeNotFoundException {
        Object jsonResult;
        this.setupContext(pOpts);
        try {
            jsonResult = this.extractObject(pValue, pExtraArgs, pJsonify);
        }
        catch (ValueFaultHandler.AttributeFilteredException exp) {
            jsonResult = null;
        }
        finally {
            this.clearContext();
        }
        return jsonResult;
    }

    private Object setObjectValue(Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        Class<?> clazz = pInner.getClass();
        if (clazz.isArray()) {
            return this.arrayAccessor.setObjectValue(this.objectToObjectConverter, pInner, pAttribute, pValue);
        }
        ObjectAccessor objectAccessor = this.getWriteAccessor(clazz);
        if (objectAccessor != null) {
            return objectAccessor.setObjectValue(this.objectToObjectConverter, pInner, pAttribute, pValue);
        }
        throw new IllegalStateException("Internal error: No ObjectAccessor found for class " + String.valueOf(clazz) + " for setting object value. (object: " + String.valueOf(pInner) + ", attribute: " + pAttribute + ", value: " + String.valueOf(pValue) + ")");
    }

    int getCollectionLength(int originalLength) {
        ObjectSerializationContext ctx = this.stackContextLocal.get();
        return ctx.getCollectionSizeTruncated(originalLength);
    }

    Converter<String> getConverter() {
        return this.objectToObjectConverter;
    }

    String getSerializeLong() {
        ObjectSerializationContext ctx = this.stackContextLocal.get();
        return ctx.getSerializeLong();
    }

    public ValueFaultHandler getValueFaultHandler() {
        ObjectSerializationContext ctx = this.stackContextLocal.get();
        return ctx.getValueFaultHandler();
    }

    void clearContext() {
        this.stackContextLocal.remove();
    }

    void setupContext() {
        this.setupContext(new SerializeOptions.Builder().build());
    }

    void setupContext(SerializeOptions pOpts) {
        ObjectSerializationContext stackContext = new ObjectSerializationContext(pOpts);
        this.stackContextLocal.set(stackContext);
    }

    private ObjectAccessor getWriteAccessor(Class<?> pClazz) {
        ObjectAccessor accessor = this.cachedAccessor(pClazz);
        if (accessor != null && accessor.canSetValue()) {
            return accessor;
        }
        return null;
    }

    private Object invokeAccessor(Object pValue, Deque<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        Class<?> cls = pValue.getClass();
        ObjectAccessor accessor = this.cachedAccessor(cls);
        if (accessor != null) {
            return accessor.extractObject(this, pValue, pPathParts, pJsonify);
        }
        throw new IllegalStateException("Internal error: No ObjectAccessor found for class " + String.valueOf(cls));
    }

    private ObjectAccessor cachedAccessor(Class<?> pClazz) {
        ObjectAccessor found = this.ACCESSORS_CACHE.get(pClazz);
        if (found != null) {
            return found;
        }
        for (ObjectAccessor accessor : this.objectAccessors) {
            if (accessor.getType() == null || !accessor.getType().isAssignableFrom(pClazz)) continue;
            this.ACCESSORS_CACHE.put(pClazz, accessor);
            return accessor;
        }
        return null;
    }

    private String checkForLimits(Object pValue, ObjectSerializationContext pStackContext) {
        if (pValue != null) {
            if (pStackContext.maxDepthReached()) {
                return pValue.toString();
            }
            if (pStackContext.alreadyVisited(pValue)) {
                return "[Reference " + pValue.getClass().getName() + "@" + Integer.toHexString(pValue.hashCode()) + "]";
            }
        }
        if (pStackContext.maxObjectsExceeded()) {
            return "[Object limit exceeded]";
        }
        return null;
    }

    ThreadLocal<ObjectSerializationContext> getStackContextLocal() {
        return this.stackContextLocal;
    }

    private void loadSimplifiers(List<SimplifierAccessor<?>> pSimplifiers, CoreConfiguration coreConfig) {
        List services = LocalServiceFactory.createServices(this.getClass().getClassLoader(), SIMPLIFIERS_DEFAULT_DEF, SIMPLIFIERS_DEF);
        pSimplifiers.addAll(services);
    }
}

