/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.jolokia.core.service.serializer.SerializeOptions;
import org.jolokia.core.service.serializer.ValueFaultHandler;

class ObjectSerializationContext {
    private static final Set<Class<?>> SIMPLE_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, Date.class, BigInteger.class, BigDecimal.class));
    private final Set<Integer> objectsInCallStack = new HashSet<Integer>();
    private final SerializeOptions options;
    private int objectCount = 0;

    ObjectSerializationContext(SerializeOptions pOpts) {
        this.options = pOpts;
    }

    boolean alreadyVisited(Object object) {
        return this.objectsInCallStack.contains(System.identityHashCode(object));
    }

    public boolean maxDepthReached() {
        return this.options.maxDepthReached(this.objectsInCallStack.size());
    }

    public boolean maxObjectsExceeded() {
        return this.options.maxObjectExceeded(this.objectCount);
    }

    public int getCollectionSizeTruncated(int pCollectionSize) {
        return this.options.getCollectionSizeTruncated(pCollectionSize);
    }

    public String getSerializeLong() {
        return this.options.getSerializeLong();
    }

    public ValueFaultHandler getValueFaultHandler() {
        return this.options.getValueFaultHandler();
    }

    void push(Object object) {
        if (object != null && !SIMPLE_TYPES.contains(object.getClass())) {
            this.objectsInCallStack.add(System.identityHashCode(object));
            ++this.objectCount;
        }
    }

    void pop(Object value) {
        if (value != null && !SIMPLE_TYPES.contains(value.getClass())) {
            this.objectsInCallStack.remove(System.identityHashCode(value));
        }
    }
}

