/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.util.Deque;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.json.ObjectAccessor;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.object.Converter;

public class EnumObjectAccessor
implements ObjectAccessor {
    @Override
    public Class<?> getType() {
        return Enum.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Deque<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        String pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        Enum en = (Enum)pValue;
        String name = en.name();
        if (pathPart != null) {
            if (name.equals(pathPart)) {
                return name;
            }
            return pConverter.getValueFaultHandler().handleException(new AttributeNotFoundException("Enum value '" + name + "' doesn't match path '" + pathPart + "'"));
        }
        return pJsonify ? name : en;
    }

    @Override
    public boolean supportsStringConversion() {
        return true;
    }

    @Override
    public String extractString(Object pValue) {
        return ((Enum)pValue).name();
    }

    @Override
    public boolean canSetValue() {
        return false;
    }

    @Override
    public Object setObjectValue(Converter<String> pConverter, Object pObject, String pAttribute, Object pValue) {
        throw new UnsupportedOperationException("An enum itself is immutable and cannot change its value");
    }
}

