/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.zone.ZoneRules;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import org.jolokia.core.config.CoreConfiguration;

public class DateFormatConfiguration {
    private static final String defaultDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSXXX";
    private static final TimeZone defaultTimeZone = TimeZone.getDefault();
    private boolean useUnixTime = false;
    private boolean useUnixTimestamp = false;
    private boolean useUnixMillis = false;
    private boolean useUnixNanos = false;
    private final ZoneId zone;
    private DateFormat simpleDateFormat;
    private DateTimeFormatter dateTimeFormatter;

    public DateFormatConfiguration() {
        this(defaultDateFormat, defaultTimeZone);
    }

    public DateFormatConfiguration(String format, String timeZone) {
        this(format, timeZone == null ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZone));
    }

    public DateFormatConfiguration(CoreConfiguration coreConfiguration) {
        this(coreConfiguration == null ? defaultDateFormat : coreConfiguration.dateFormat(), coreConfiguration == null ? defaultTimeZone : coreConfiguration.dateFormatTimeZone());
    }

    public DateFormatConfiguration(String format, TimeZone timeZone) {
        TimeZone dateFormatZone = timeZone == null ? TimeZone.getDefault() : timeZone;
        this.zone = dateFormatZone.toZoneId();
        if ("time".equals(format) || "long".equals(format) || "millis".equals(format)) {
            this.useUnixMillis = true;
            this.useUnixTime = true;
        } else if ("unix".equals(format)) {
            this.useUnixTimestamp = true;
            this.useUnixTime = true;
        } else if ("nanos".equals(format)) {
            this.useUnixNanos = true;
            this.useUnixTime = true;
        } else {
            try {
                String dateFormat = format;
                if (dateFormat.matches(".*S{4,}.*")) {
                    dateFormat = dateFormat.replaceAll("S{4,}", "SSS");
                }
                this.simpleDateFormat = new SimpleDateFormat(dateFormat);
                this.simpleDateFormat.setTimeZone(dateFormatZone);
            }
            catch (IllegalArgumentException e) {
                this.simpleDateFormat = new SimpleDateFormat(defaultDateFormat);
                this.simpleDateFormat.setTimeZone(TimeZone.getDefault());
            }
            try {
                this.dateTimeFormatter = DateTimeFormatter.ofPattern(format).withZone(dateFormatZone.toZoneId());
            }
            catch (IllegalArgumentException e) {
                this.dateTimeFormatter = DateTimeFormatter.ofPattern(defaultDateFormat).withZone(TimeZone.getDefault().toZoneId());
            }
        }
    }

    public ZoneRules getZoneRules() {
        return this.dateTimeFormatter.getZone().getRules();
    }

    public Set<TemporalField> getResolverFields() {
        return this.dateTimeFormatter.getResolverFields();
    }

    public boolean usesUnixTime() {
        return this.useUnixTime;
    }

    public boolean usesUnixTime(Temporal temporal) {
        return this.useUnixTime && temporal.isSupported(ChronoField.INSTANT_SECONDS);
    }

    public Long toUnixTime(Date date) {
        if (this.useUnixMillis) {
            return date.getTime();
        }
        if (this.useUnixTimestamp) {
            return date.getTime() / 1000L;
        }
        if (this.useUnixNanos) {
            return date.getTime() * 1000000L;
        }
        return null;
    }

    public Date unixTimeToDate(Long v) {
        if (!this.useUnixTime) {
            throw new IllegalArgumentException("DateConfiguration is not configured to support UNIX timestamps");
        }
        if (this.useUnixMillis) {
            return new Date(v);
        }
        if (this.useUnixTimestamp) {
            return new Date(v * 1000L);
        }
        if (this.useUnixNanos) {
            return new Date(v / 1000000L);
        }
        return null;
    }

    public Date unixTimeInMillisToDate(Long v) {
        return new Date(v);
    }

    public Long toUnixTime(Calendar calendar) {
        if (this.useUnixMillis) {
            return calendar.getTimeInMillis();
        }
        if (this.useUnixTimestamp) {
            return calendar.getTimeInMillis() / 1000L;
        }
        if (this.useUnixNanos) {
            return calendar.getTimeInMillis() * 1000000L;
        }
        return null;
    }

    public Long toUnixTime(Temporal temporal) {
        if (this.useUnixTimestamp) {
            return temporal.getLong(ChronoField.INSTANT_SECONDS);
        }
        if (this.useUnixMillis) {
            return temporal.getLong(ChronoField.INSTANT_SECONDS) * 1000L + temporal.getLong(ChronoField.MILLI_OF_SECOND);
        }
        if (this.useUnixNanos) {
            return temporal.getLong(ChronoField.INSTANT_SECONDS) * 1000000000L + temporal.getLong(ChronoField.NANO_OF_SECOND);
        }
        return null;
    }

    public Object unixTimeToTemporal(Class<?> temporalType, Long v) {
        if (!this.useUnixTime) {
            throw new IllegalArgumentException("DateConfiguration is not configured to support UNIX timestamps");
        }
        long seconds = 0L;
        long nanos = 0L;
        if (this.useUnixMillis) {
            seconds = v / 1000L;
            nanos = v % 1000L;
        }
        if (this.useUnixTimestamp) {
            seconds = v;
            nanos = 0L;
        }
        if (this.useUnixNanos) {
            seconds = v / 1000000000L;
            nanos = v % 1000000000L;
        }
        Instant instant = Instant.ofEpochSecond(seconds, nanos);
        return this.instantToTemporal(temporalType, instant);
    }

    public Object unixTimeInNanosToTemporal(Class<?> temporalType, Long v) {
        Instant instant = Instant.ofEpochSecond(v / 1000000000L, v % 1000000000L);
        return this.instantToTemporal(temporalType, instant);
    }

    private Object instantToTemporal(Class<?> temporalType, Instant instant) {
        if (temporalType == Instant.class) {
            return instant;
        }
        ZonedDateTime zdt = instant.atZone(this.zone);
        if (temporalType == LocalDate.class) {
            return zdt.toLocalDate();
        }
        if (temporalType == LocalDateTime.class) {
            return zdt.toLocalDateTime();
        }
        if (temporalType == LocalTime.class) {
            return zdt.toLocalTime();
        }
        if (temporalType == OffsetDateTime.class) {
            return zdt.toOffsetDateTime();
        }
        if (temporalType == OffsetTime.class) {
            return zdt.toOffsetDateTime().toOffsetTime();
        }
        if (temporalType == Year.class) {
            return Year.of(zdt.getYear());
        }
        if (temporalType == YearMonth.class) {
            return YearMonth.of(zdt.getYear(), zdt.getMonthValue());
        }
        return zdt;
    }

    public String format(Date date) {
        return this.simpleDateFormat.format(date);
    }

    public String format(Calendar cal) {
        return this.simpleDateFormat.format(cal.getTime());
    }

    public String format(Temporal temporal) {
        return this.dateTimeFormatter.format(temporal);
    }

    public Date parseAsDate(String value) throws ParseException {
        return this.simpleDateFormat.parse(value);
    }

    public Temporal parseAsTemporal(Class<?> temporalType, String pValue) {
        TemporalAccessor accessor = this.dateTimeFormatter.parse(pValue);
        if (temporalType == Instant.class) {
            return Instant.from(accessor);
        }
        if (temporalType == LocalDate.class) {
            return LocalDate.from(accessor);
        }
        if (temporalType == LocalDateTime.class) {
            return LocalDateTime.from(accessor);
        }
        if (temporalType == LocalTime.class) {
            return LocalTime.from(accessor);
        }
        if (temporalType == OffsetDateTime.class) {
            return OffsetDateTime.from(accessor);
        }
        if (temporalType == OffsetTime.class) {
            return OffsetTime.from(accessor);
        }
        if (temporalType == Year.class) {
            return Year.from(accessor);
        }
        if (temporalType == YearMonth.class) {
            return YearMonth.from(accessor);
        }
        return ZonedDateTime.from(accessor);
    }
}

