/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.text.ParseException;
import java.util.Date;
import java.util.Deque;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.json.DateFormatConfiguration;
import org.jolokia.converter.json.ObjectAccessor;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.object.Converter;
import org.jolokia.core.util.DateUtil;

public class DateAccessor
implements ObjectAccessor {
    private final DateFormatConfiguration configuration;

    public DateAccessor(DateFormatConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Class<?> getType() {
        return Date.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pDate, Deque<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        String pathPart;
        if (!pJsonify || pDate == null) {
            return pDate;
        }
        Date date = (Date)pDate;
        if (this.configuration.usesUnixTime()) {
            return this.configuration.toUnixTime(date);
        }
        String string = pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathPart != null) {
            if (!"time".equals(pathPart)) {
                return pConverter.getValueFaultHandler().handleException(new AttributeNotFoundException("A date accepts only a single inner path element of value 'time' (and not '" + pathPart + "')"));
            }
            return date.getTime();
        }
        return this.configuration.format(date);
    }

    @Override
    public boolean supportsStringConversion() {
        return true;
    }

    @Override
    public String extractString(Object pDate) {
        Date date = (Date)pDate;
        if (this.configuration.usesUnixTime()) {
            return Long.toString(this.configuration.toUnixTime(date));
        }
        return this.configuration.format(date);
    }

    @Override
    public boolean canSetValue() {
        return true;
    }

    @Override
    public Object setObjectValue(Converter<String> pConverter, Object pDate, String pAttribute, Object pValue) {
        Date date = (Date)pDate;
        if ("time".equals(pAttribute)) {
            long oldValue = date.getTime();
            long time = pValue instanceof String ? Long.parseLong((String)pValue) : (Long)pValue;
            date.setTime(time);
            return oldValue;
        }
        if ("iso8601".equals(pAttribute)) {
            Date newDate = DateUtil.fromISO8601(pValue.toString());
            String oldValue = DateUtil.toISO8601(date);
            date.setTime(newDate.getTime());
            return oldValue;
        }
        if ("format".equals(pAttribute)) {
            try {
                Date newDate = this.configuration.parseAsDate(pValue.toString());
                String oldValue = this.configuration.format(date);
                date.setTime(newDate.getTime());
                return oldValue;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        throw new UnsupportedOperationException("Setting of date values is not yet supported directly. Use a path/attribute 'time', 'iso8601' or 'format' to set the epoch seconds on a date");
    }
}

