/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Deque;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.json.DateFormatConfiguration;
import org.jolokia.converter.json.ObjectAccessor;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.object.Converter;
import org.jolokia.core.util.DateUtil;

public class CalendarAccessor
implements ObjectAccessor {
    private final DateFormatConfiguration configuration;

    public CalendarAccessor(DateFormatConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Class<?> getType() {
        return Calendar.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pCalendar, Deque<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        String pathPart;
        if (!pJsonify || pCalendar == null) {
            return pCalendar;
        }
        Calendar cal = (Calendar)pCalendar;
        if (this.configuration.usesUnixTime()) {
            return this.configuration.toUnixTime(cal);
        }
        String string = pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathPart != null) {
            if (!"time".equals(pathPart)) {
                return pConverter.getValueFaultHandler().handleException(new AttributeNotFoundException("A calendar accepts only a single inner path element of value 'time' (and not '" + pathPart + "')"));
            }
            return cal.getTimeInMillis();
        }
        return this.configuration.format(cal);
    }

    @Override
    public boolean supportsStringConversion() {
        return true;
    }

    @Override
    public String extractString(Object pCalendar) {
        Calendar calendar = (Calendar)pCalendar;
        if (this.configuration.usesUnixTime()) {
            return Long.toString(this.configuration.toUnixTime(calendar));
        }
        return this.configuration.format(calendar);
    }

    @Override
    public boolean canSetValue() {
        return true;
    }

    @Override
    public Object setObjectValue(Converter<String> pConverter, Object pCalendar, String pAttribute, Object pValue) {
        Calendar cal = (Calendar)pCalendar;
        if ("time".equals(pAttribute)) {
            long oldValue = cal.getTime().getTime();
            long time = pValue instanceof String ? Long.parseLong((String)pValue) : (Long)pValue;
            cal.setTime(new Date(time));
            return oldValue;
        }
        if ("iso8601".equals(pAttribute)) {
            Date newDate = DateUtil.fromISO8601(pValue.toString());
            String oldValue = DateUtil.toISO8601(cal.getTime());
            cal.setTime(newDate);
            return oldValue;
        }
        if ("format".equals(pAttribute)) {
            try {
                Date newDate = this.configuration.parseAsDate(pValue.toString());
                String oldValue = this.configuration.format(cal);
                cal.setTime(newDate);
                return oldValue;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        throw new UnsupportedOperationException("Setting of calendar values is not yet supported directly. Use a path/attribute 'time', 'iso8601' or 'format' to set the epoch seconds on a date of the calendar");
    }
}

