/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.module.ModuleFinder;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.nio.channels.Channel;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.json.ObjectAccessor;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.object.Converter;
import org.jolokia.core.service.serializer.ValueFaultHandler;
import org.jolokia.core.util.EscapeUtil;
import org.jolokia.json.JSONObject;

public class BeanAccessor
implements ObjectAccessor {
    private static final Set<String> IGNORED_GETTERS = Set.of("getClass", "getStackTrace", "getClassLoader");
    private static final Class<?>[] IGNORED_RETURN_TYPES = new Class[]{OutputStream.class, InputStream.class, Writer.class, Reader.class, Socket.class, ServerSocket.class, Channel.class, System.class, Runtime.class, Process.class};
    private static final Set<Class<?>> NO_ATTRIBUTE_CLASSES = Set.of(URI.class, UUID.class, Locale.class);
    private static final Set<Package> IGNORED_PACKAGES = Set.of(ModuleFinder.class.getPackage(), Reference.class.getPackage(), Field.class.getPackage());
    private static final String[] GETTER_PREFIX = new String[]{"get", "is", "has"};
    private static final List<AttributeAndMethod> NO_ATTRIBUTES = Collections.emptyList();
    private final Map<Class<?>, Map<String, AttributeAndMethod>> ATTRIBUTE_CACHE = Collections.synchronizedMap(new HashMap());
    private final Set<Class<?>> CACHE_IGNORED = new HashSet();

    @Override
    public Class<?> getType() {
        return Object.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Deque<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        String pathPart;
        String string = pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathPart != null) {
            this.collectValidBeanAttributes(pValue);
            Map<String, AttributeAndMethod> attributes = this.ATTRIBUTE_CACHE.get(pValue.getClass());
            AttributeAndMethod attr = attributes.get(pathPart);
            if (attr == null) {
                attr = new AttributeAndMethod(pathPart, null);
            }
            Object attributeValue = this.extractBeanPropertyValue(pValue, attr, pConverter.getValueFaultHandler());
            return pConverter.extractObject(attributeValue, pPathParts, pJsonify);
        }
        return pJsonify ? this.objectToJSON(pConverter, pValue, pPathParts) : pValue;
    }

    @Override
    public boolean canSetValue() {
        return true;
    }

    @Override
    public Object setObjectValue(Converter<String> pConverter, Object pObject, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        Object oldValue;
        String property = Character.toUpperCase(pAttribute.charAt(0)) + pAttribute.substring(1);
        String setter = "set" + property;
        String getter = "get" + property;
        Class<?> clazz = pObject.getClass();
        Method found = null;
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(setter)) continue;
            found = method;
            break;
        }
        if (found == null) {
            throw new IllegalArgumentException("No Method " + setter + " known for object of type " + clazz.getName());
        }
        Class<?>[] params = found.getParameterTypes();
        if (params.length != 1) {
            throw new IllegalArgumentException("Invalid parameter signature for " + setter + " known for object of type " + clazz.getName() + ". Setter must take exactly one parameter.");
        }
        try {
            Method getMethod = clazz.getMethod(getter, new Class[0]);
            oldValue = getMethod.invoke(pObject, new Object[0]);
        }
        catch (NoSuchMethodException exp) {
            oldValue = null;
        }
        found.invoke(pObject, pConverter.convert(params[0].getName(), pValue));
        return oldValue;
    }

    private Object objectToJSON(ObjectToJsonConverter pConverter, Object pValue, Deque<String> pPathParts) throws AttributeNotFoundException {
        Class<?> clazz = pValue.getClass();
        Collection<AttributeAndMethod> attributes = this.collectValidBeanAttributes(pValue);
        if (!attributes.isEmpty()) {
            return this.extractBeanPropertyValues(pConverter, pValue, pPathParts, attributes);
        }
        return pConverter.getConverter().convert(String.class.getName(), pValue);
    }

    private Collection<AttributeAndMethod> collectValidBeanAttributes(Object pValue) {
        Class<?> cls = pValue.getClass();
        Map<String, AttributeAndMethod> attributes = this.ATTRIBUTE_CACHE.get(cls);
        if (attributes != null) {
            return attributes.values();
        }
        if (NO_ATTRIBUTE_CLASSES.contains(cls)) {
            return NO_ATTRIBUTES;
        }
        attributes = new HashMap<String, AttributeAndMethod>();
        for (Method method : cls.getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || IGNORED_GETTERS.contains(method.getName()) || this.isIgnoredType(method.getReturnType()) || this.hasAnnotation(method, "java.beans.Transient")) continue;
            String name = method.getName();
            for (String pref : GETTER_PREFIX) {
                int len;
                char firstLetter;
                if (!name.startsWith(pref) || name.length() <= pref.length() || method.getParameterTypes().length != 0 || !Character.isUpperCase(firstLetter = name.charAt(len = pref.length()))) continue;
                String attributeName = Character.toLowerCase(firstLetter) + name.substring(len + 1);
                attributes.put(attributeName, new AttributeAndMethod(attributeName, method));
            }
        }
        this.ATTRIBUTE_CACHE.put(cls, Collections.unmodifiableMap(attributes));
        return attributes.values();
    }

    private Object extractBeanPropertyValues(ObjectToJsonConverter pConverter, Object pValue, Deque<String> pPathParts, Collection<AttributeAndMethod> pAttributes) throws AttributeNotFoundException {
        JSONObject ret = new JSONObject();
        for (AttributeAndMethod attribute : pAttributes) {
            LinkedList<String> path = new LinkedList<String>(pPathParts);
            try {
                ret.put(attribute.name, this.extractBeanPropertyValueAsJSON(pConverter, pValue, attribute, path));
            }
            catch (ValueFaultHandler.AttributeFilteredException attributeFilteredException) {}
        }
        if (ret.isEmpty() && !pAttributes.isEmpty()) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }

    private Object extractBeanPropertyValueAsJSON(ObjectToJsonConverter pConverter, Object pValue, AttributeAndMethod pAttribute, Deque<String> pPathParts) throws AttributeNotFoundException {
        ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
        Object value = this.extractBeanPropertyValue(pValue, pAttribute, faultHandler);
        if (value == null) {
            if (!pPathParts.isEmpty()) {
                faultHandler.handleException(new AttributeNotFoundException("Cannot apply remaining path " + EscapeUtil.combineToPath(pPathParts) + " on null value"));
            }
            return null;
        }
        if (value == pValue) {
            if (!pPathParts.isEmpty()) {
                faultHandler.handleException(new AttributeNotFoundException("Cannot apply remaining path " + EscapeUtil.combineToPath(pPathParts) + " on a cycle"));
            }
            return "[this]";
        }
        return pConverter.extractObject(value, pPathParts, true);
    }

    private Object extractBeanPropertyValue(Object pValue, AttributeAndMethod pAttribute, ValueFaultHandler pFaultHandler) throws AttributeNotFoundException {
        Class<?> clazz = pValue.getClass();
        if (pAttribute.method == null) {
            return pFaultHandler.handleException(new AttributeNotFoundException("No getter known for attribute \"" + pAttribute.name + "\" for class " + pValue.getClass().getName()));
        }
        try {
            return pAttribute.method.invoke(pValue, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return pFaultHandler.handleException(new IllegalStateException("Error while extracting " + String.valueOf(pAttribute) + " from " + String.valueOf(pValue), e));
        }
    }

    private boolean isIgnoredType(Class<?> pType) {
        if (this.CACHE_IGNORED.contains(pType) || !pType.isPrimitive() && !pType.isArray() && IGNORED_PACKAGES.contains(pType.getPackage())) {
            return true;
        }
        for (Class<?> type : IGNORED_RETURN_TYPES) {
            if (!type.isAssignableFrom(pType)) continue;
            this.CACHE_IGNORED.add(pType);
            return true;
        }
        return false;
    }

    private boolean hasAnnotation(Method method, String annotation) {
        for (Annotation anno : method.getAnnotations()) {
            if (!anno.annotationType().getName().equals(annotation)) continue;
            return true;
        }
        return false;
    }

    private static final class AttributeAndMethod {
        final String name;
        final Method method;

        private AttributeAndMethod(String name, Method method) {
            this.name = name;
            this.method = method;
        }

        public String toString() {
            return this.name + "/" + this.method.getReturnType().getName() + " " + this.method.getName() + "()";
        }
    }
}

