/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.asn1;

import org.jolokia.asn1.DERBitString;
import org.jolokia.asn1.DERBoolean;
import org.jolokia.asn1.DERContextSpecific;
import org.jolokia.asn1.DERInteger;
import org.jolokia.asn1.DERLength;
import org.jolokia.asn1.DERNull;
import org.jolokia.asn1.DERObject;
import org.jolokia.asn1.DERObjectIdentifier;
import org.jolokia.asn1.DEROctetString;
import org.jolokia.asn1.DERSequence;

public class DERUtils {
    private DERUtils() {
    }

    public static byte[] encodeLength(int size) {
        int start;
        if (size < 0) {
            throw new IllegalArgumentException("Can't encode negative length");
        }
        int s = size;
        byte[] lengthEncoded = new byte[4];
        for (int i = 3; i >= 0; --i) {
            lengthEncoded[i] = (byte)(s & 0xFF);
            s >>>= 8;
        }
        for (start = 0; start < 4 && lengthEncoded[start] == 0; ++start) {
        }
        if (size <= 127) {
            return new byte[]{lengthEncoded[3]};
        }
        byte[] result = new byte[4 - start + 1];
        result[0] = (byte)(4 - start | 0x80);
        System.arraycopy(lengthEncoded, start, result, 1, 4 - start);
        return result;
    }

    public static DERLength decodeLength(byte[] encoded) {
        return DERUtils.decodeLength(encoded, 0);
    }

    public static DERLength decodeLength(byte[] encoded, int offset) {
        if (offset >= encoded.length) {
            throw new IllegalArgumentException("Can't decode DER value length - end of data");
        }
        if (encoded[offset] == -128) {
            throw new IllegalArgumentException("DER value with indefinite length is not supported");
        }
        if ((encoded[offset] & 0x80) == 0) {
            return new DERLength(encoded[offset], 1);
        }
        int ll = encoded[offset] & 0x7F;
        if (ll > 4) {
            throw new IllegalArgumentException("Can't decode DER value with length encoded on more than 4 octets");
        }
        int lengthOctets = ll;
        if (offset + ll >= encoded.length) {
            throw new IllegalArgumentException("Can't decode DER value length - end of data");
        }
        long length = 0L;
        while (ll > 0) {
            length |= (long)(encoded[++offset] & 0xFF) << --ll * 8;
        }
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Can't decode DER value longer than 2147483647");
        }
        return new DERLength((int)length, 1 + lengthOctets);
    }

    public static DERObject parse(byte[] encoded) {
        return DERUtils.parse(encoded, 0);
    }

    public static DERObject parse(byte[] encoded, int offset) {
        if (encoded == null || encoded.length < 2) {
            throw new IllegalArgumentException("Can't DER-decode null/empty/insufficient byte array");
        }
        byte id = encoded[offset];
        int cls = id & 0xC0;
        boolean primitive = (id & 0x20) == 0;
        boolean universal = (id & 0xC0) == 0;
        boolean contextSpecific = (id & 0xC0) == 128;
        int tag = id & 0x1F;
        if (tag == 31) {
            throw new IllegalArgumentException("Can't decode tags with number higher than 30");
        }
        DERLength lo = DERUtils.decodeLength(encoded, offset + 1);
        if (universal) {
            switch (tag) {
                case 1: {
                    return DERBoolean.parse(encoded, offset + 1);
                }
                case 2: {
                    return DERInteger.parse(encoded, lo.length(), offset + 1 + lo.lengthOctets());
                }
                case 3: {
                    return DERBitString.parse(encoded, lo.length(), offset + 1 + lo.lengthOctets());
                }
                case 4: {
                    return DEROctetString.parse((byte)4, encoded, lo.length(), offset + 1 + lo.lengthOctets());
                }
                case 5: {
                    return new DERNull();
                }
                case 6: {
                    return DERObjectIdentifier.parse(encoded, lo.length(), offset + 1 + lo.lengthOctets());
                }
                case 10: {
                    break;
                }
                case 12: {
                    return DEROctetString.parse((byte)12, encoded, lo.length(), offset + 1 + lo.lengthOctets());
                }
                case 16: {
                    return DERSequence.parse(encoded, lo.length(), offset + 1 + lo.lengthOctets());
                }
                case 17: {
                    break;
                }
                case 18: {
                    break;
                }
                case 19: {
                    return DEROctetString.parse((byte)19, encoded, lo.length(), offset + 1 + lo.lengthOctets());
                }
                case 22: {
                    return DEROctetString.parse((byte)22, encoded, lo.length(), offset + 1 + lo.lengthOctets());
                }
                case 23: {
                    break;
                }
                case 26: {
                    break;
                }
                case 27: {
                    break;
                }
                case 28: {
                    break;
                }
            }
        }
        if (contextSpecific) {
            return DERContextSpecific.parse((byte)tag, DERContextSpecific.TagMode.EXPLICIT, primitive, encoded, lo.length(), offset + 1, lo.lengthOctets());
        }
        throw new IllegalArgumentException("Unsupported ASN.1 tag " + id);
    }
}

