/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.asn1;

import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jolokia.asn1.DERObject;

public class DERUtcTime
implements DERObject {
    private static final DateFormat UTC = new SimpleDateFormat("yyMMddHHmmss'Z'");
    public static final byte DER_UTCTIME_TAG = 23;
    private final Date value;

    public DERUtcTime(Date value) {
        this.value = value;
    }

    @Override
    public byte getTag() {
        return 23;
    }

    @Override
    public String getTagAsString() {
        return "UTCTIME";
    }

    @Override
    public byte[] getEncoded() {
        String utctime = UTC.format(this.value);
        byte[] result = new byte[15];
        result[0] = 23;
        result[1] = 13;
        System.arraycopy(utctime.getBytes(StandardCharsets.UTF_8), 0, result, 2, 13);
        return result;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public String toString() {
        return UTC.format(this.value);
    }

    static {
        UTC.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

