/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jolokia.asn1.DERObject;
import org.jolokia.asn1.DERUtils;

public class DERTaggedObject
implements DERObject {
    private final TagClass tagClass;
    private final boolean primitive;
    private final byte tagNumber;
    private final DERObject value;

    public DERTaggedObject(TagClass tagClass, boolean primitive, int tagNumber, DERObject value) {
        if (tagNumber > 30) {
            throw new IllegalArgumentException("Only tag numbers 0-30 are supported");
        }
        this.tagClass = tagClass;
        this.primitive = primitive;
        this.tagNumber = (byte)(tagNumber & 0x1F);
        this.value = value;
    }

    @Override
    public byte getTag() {
        return this.tagNumber;
    }

    @Override
    public String getTagAsString() {
        return this.tagClass.name() + "(" + this.tagNumber + ")";
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        try {
            content.write(this.value.getEncoded());
            byte[] bytes = content.toByteArray();
            byte tag = this.tagClass.encoded;
            if (!this.primitive) {
                tag = (byte)(tag | 0x20);
            }
            tag = (byte)(tag | this.tagNumber);
            result.write(tag);
            result.write(DERUtils.encodeLength(bytes.length));
            result.write(bytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toByteArray();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public String toString() {
        return this.getTagAsString() + ": " + this.value.toString();
    }

    public static enum TagClass {
        Universal(0),
        Application(64),
        ContextSpecific(-128),
        Private(-64);

        private final byte encoded;

        private TagClass(byte encoded) {
            this.encoded = encoded;
        }

        public byte getEncoded() {
            return this.encoded;
        }
    }
}

