/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jolokia.asn1.DERObject;
import org.jolokia.asn1.DERUtils;

public class DERSet
implements DERObject {
    public static final byte DER_SET_TAG = 49;
    private final DERObject[] values;

    public DERSet(DERObject[] values) {
        this.values = values;
    }

    @Override
    public byte getTag() {
        return 49;
    }

    @Override
    public String getTagAsString() {
        return "SET";
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        try {
            for (DERObject v : this.values) {
                content.write(v.getEncoded());
            }
            byte[] bytes = content.toByteArray();
            result.write(49);
            result.write(DERUtils.encodeLength(bytes.length));
            result.write(bytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toByteArray();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public DERObject[] getValues() {
        return this.values;
    }
}

