/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.jolokia.asn1.DERLength;
import org.jolokia.asn1.DERObject;
import org.jolokia.asn1.DERUtils;

public class DERSequence
implements DERObject {
    public static final byte DER_SEQUENCE_TAG = 48;
    private final DERObject[] values;

    public DERSequence(DERObject[] values) {
        this.values = values;
    }

    @Override
    public byte getTag() {
        return 48;
    }

    @Override
    public String getTagAsString() {
        return "SEQUENCE";
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        try {
            for (DERObject v : this.values) {
                content.write(v.getEncoded());
            }
            byte[] bytes = content.toByteArray();
            result.write(48);
            result.write(DERUtils.encodeLength(bytes.length));
            result.write(bytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toByteArray();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public DERObject[] getValues() {
        return this.values;
    }

    public static DERObject parse(byte[] encoded, int length, int offset) {
        DERLength lo;
        ArrayList<DERObject> objects = new ArrayList<DERObject>();
        for (int pos = offset; pos < offset + length; pos += 1 + lo.length() + lo.lengthOctets()) {
            lo = DERUtils.decodeLength(encoded, pos + 1);
            DERObject el = DERUtils.parse(encoded, pos);
            objects.add(el);
        }
        return new DERSequence((DERObject[])objects.toArray(DERObject[]::new));
    }
}

