/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.asn1;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jolokia.asn1.DERObject;

public class DEROctetString
implements DERObject {
    public static final byte DER_OCTETSTRING_TAG = 4;
    public static final byte DER_UTF8STRING_TAG = 12;
    public static final byte DER_PRINTABLESTRING_TAG = 19;
    public static final byte DER_IA5STRING_TAG = 22;
    private final byte tag;
    private final String value;
    private final byte[] bytes;

    public DEROctetString(byte tag, byte[] value) {
        if (value.length > 65535) {
            throw new IllegalArgumentException("Can't DER encoded Strings longer than 64KiB");
        }
        this.tag = tag;
        this.value = null;
        this.bytes = value;
    }

    public DEROctetString(byte tag, String value) {
        if (value.length() > 65535) {
            throw new IllegalArgumentException("Can't DER encoded Strings longer than 64KiB");
        }
        this.tag = tag;
        this.value = value;
        this.bytes = null;
    }

    @Override
    public byte getTag() {
        return this.tag;
    }

    @Override
    public String getTagAsString() {
        switch (this.tag) {
            case 4: {
                return "OCTETSTRING";
            }
            case 12: {
                return "UTF8STRING";
            }
            case 19: {
                return "PRINTABLESTRING";
            }
            case 22: {
                return "IA5STRING";
            }
        }
        return "<unknown string>";
    }

    @Override
    public byte[] getEncoded() {
        byte[] bytes;
        byte[] byArray = bytes = this.bytes != null ? this.bytes : this.value.getBytes(StandardCharsets.UTF_8);
        if (bytes.length < 128) {
            byte[] result = new byte[bytes.length + 2];
            result[0] = this.tag;
            result[1] = (byte)bytes.length;
            System.arraycopy(bytes, 0, result, 2, bytes.length);
            return result;
        }
        if (bytes.length <= 256) {
            byte[] result = new byte[bytes.length + 3];
            result[0] = this.tag;
            result[1] = -127;
            result[2] = (byte)bytes.length;
            System.arraycopy(bytes, 0, result, 3, bytes.length);
            return result;
        }
        byte[] result = new byte[bytes.length + 4];
        result[0] = this.tag;
        result[1] = -126;
        result[2] = (byte)((bytes.length & 0xFF00) >> 8);
        result[3] = (byte)(bytes.length & 0xFF);
        System.arraycopy(bytes, 0, result, 4, bytes.length);
        return result;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public String toString() {
        return this.tag == 12 ? this.getString() : "<non-UTF8 string [" + this.getBytes().length + "]>";
    }

    public byte[] getBytes() {
        if (this.bytes != null) {
            return this.bytes;
        }
        if (this.value == null) {
            return null;
        }
        switch (this.tag) {
            case 12: {
                this.value.getBytes(StandardCharsets.UTF_8);
                break;
            }
            case 4: 
            case 19: 
            case 22: {
                this.value.getBytes(StandardCharsets.US_ASCII);
            }
        }
        return null;
    }

    public String getString() {
        if (this.value != null) {
            return this.value;
        }
        if (this.bytes == null) {
            return null;
        }
        return switch (this.tag) {
            case 12 -> new String(this.bytes, StandardCharsets.UTF_8);
            case 4, 19, 22 -> new String(this.bytes, StandardCharsets.US_ASCII);
            default -> throw new IllegalStateException("Unexpected value: " + this.tag);
        };
    }

    public static DEROctetString parse(byte tag, byte[] encoded, int length, int offset) {
        return new DEROctetString(tag, Arrays.copyOfRange(encoded, offset, offset + length));
    }
}

