/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.jolokia.asn1.DERDirect;
import org.jolokia.asn1.DERObject;
import org.jolokia.asn1.DERUtils;

public class DERContextSpecific
implements DERObject {
    private final byte tag;
    private final TagMode mode;
    private final boolean primitive;
    private final DERObject value;

    public DERContextSpecific(byte tag, TagMode mode, boolean primitive, DERObject value) {
        this.tag = tag;
        this.mode = mode;
        this.primitive = primitive;
        this.value = value;
        if (mode == TagMode.EXPLICIT && primitive) {
            throw new IllegalArgumentException("EXPLICIT values can not be primitive");
        }
    }

    @Override
    public byte getTag() {
        return this.tag;
    }

    @Override
    public String getTagAsString() {
        return "cont [" + this.tag + "]";
    }

    @Override
    public byte[] getEncoded() {
        byte tag = this.tag;
        if (!this.primitive) {
            tag = (byte)(tag | 0x20);
        }
        tag = (byte)(tag | 0xFFFFFF80);
        byte[] wrapped = this.value.getEncoded();
        byte[] len = DERUtils.encodeLength(wrapped.length);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (this.mode == TagMode.EXPLICIT) {
                result.write(tag);
                result.write(len);
                result.write(wrapped);
            } else {
                if (this.primitive) {
                    result.write(tag);
                } else {
                    result.write(tag | 0x20);
                }
                result.write(this.value.getEncoded(), 1, this.value.getEncoded().length - 1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toByteArray();
    }

    @Override
    public boolean isPrimitive() {
        return this.primitive;
    }

    public String toString() {
        return this.getTagAsString();
    }

    public TagMode getMode() {
        return this.mode;
    }

    public DERObject getValue() {
        return this.value;
    }

    public static DERObject parse(byte tag, TagMode mode, boolean primitive, byte[] encoded, int length, int offsetAfterTag, int lengthLength) {
        if (mode == TagMode.EXPLICIT) {
            return new DERContextSpecific(tag, mode, primitive, DERUtils.parse(encoded, offsetAfterTag + lengthLength));
        }
        return new DERContextSpecific(tag, mode, primitive, new DERDirect(Arrays.copyOfRange(encoded, offsetAfterTag - 1, 1 + lengthLength + length)));
    }

    public static enum TagMode {
        IMPLICIT,
        EXPLICIT;

    }
}

