/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.asn1;

import org.jolokia.asn1.DERObject;

public class DERBoolean
implements DERObject {
    private static final byte DER_BOOLEAN_TAG = 1;
    private final boolean value;

    public DERBoolean(boolean value) {
        this.value = value;
    }

    @Override
    public byte getTag() {
        return 1;
    }

    @Override
    public String getTagAsString() {
        return "BOOLEAN";
    }

    @Override
    public byte[] getEncoded() {
        return new byte[]{1, 1, this.value ? (byte)-1 : 0};
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    public boolean getValue() {
        return this.value;
    }

    public static DERBoolean parse(byte[] encoded, int offset) {
        return new DERBoolean(encoded[offset + 1] != 0);
    }
}

