/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jolokia.asn1.DERObject;
import org.jolokia.asn1.DERUtils;

public class DERBitString
implements DERObject {
    public static final byte DER_BITSTRING_TAG = 3;
    private final byte[] value;

    public DERBitString(byte[] value) {
        this.value = value;
    }

    @Override
    public byte getTag() {
        return 3;
    }

    @Override
    public String getTagAsString() {
        return "BITSTRING";
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        content.write(0);
        try {
            content.write(this.value);
            result.write(3);
            result.write(DERUtils.encodeLength(content.size()));
            result.write(content.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toByteArray();
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public byte[] getValue() {
        return this.value;
    }

    public static DERObject parse(byte[] encoded, int length, int offset) {
        if (encoded[offset] != 0) {
            throw new IllegalArgumentException("Can't parse BITSTRING with non-zero unused bits in the last octet");
        }
        if (length == 1) {
            return new DERBitString(new byte[0]);
        }
        byte[] result = new byte[length - 1];
        System.arraycopy(encoded, ++offset, result, 0, length - 1);
        return new DERBitString(result);
    }
}

