/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.undertow;

import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.DeploymentInfo;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import lombok.Generated;
import org.joinfaces.undertow.UndertowProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.embedded.undertow.UndertowDeploymentInfoCustomizer;

public class JsfUndertowDeploymentInfoCustomizer
implements UndertowDeploymentInfoCustomizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsfUndertowDeploymentInfoCustomizer.class);
    private final UndertowProperties undertowProperties;

    public JsfUndertowDeploymentInfoCustomizer(UndertowProperties undertowProperties) {
        this.undertowProperties = undertowProperties;
    }

    public void customize(final DeploymentInfo di) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                URLClassLoader jsfClassLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
                di.setClassLoader((ClassLoader)jsfClassLoader);
                di.setResourceManager((ResourceManager)new ClassPathResourceManager((ClassLoader)jsfClassLoader, JsfUndertowDeploymentInfoCustomizer.this.undertowProperties.getClassPathResource()));
                return null;
            }
        });
        log.info("Setting Undertow classLoader to {} directory", (Object)this.undertowProperties.getClassPathResource());
    }
}

