/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.tomcat;

import org.joinfaces.tomcat.JsfTomcatApplicationListener;
import org.joinfaces.tomcat.JsfTomcatContextCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(name={"org.apache.catalina.Context"})
@Configuration
public class TomcatSpringBootAutoConfiguration
implements EmbeddedServletContainerCustomizer {
    private JsfTomcatContextCustomizer customizer = new JsfTomcatContextCustomizer();

    @Bean
    public JsfTomcatApplicationListener jsfTomcatApplicationListener() {
        return JsfTomcatApplicationListener.builder().context(this.customizer.getContext()).build();
    }

    public void customize(ConfigurableEmbeddedServletContainer container) {
        if (container instanceof TomcatEmbeddedServletContainerFactory) {
            TomcatEmbeddedServletContainerFactory tomcatFactory = (TomcatEmbeddedServletContainerFactory)container;
            tomcatFactory.addContextCustomizers(new TomcatContextCustomizer[]{this.customizer});
        }
    }
}

