/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.tomcat;

import java.beans.ConstructorProperties;
import java.net.URL;
import lombok.Generated;
import org.apache.catalina.Context;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.catalina.webresources.JarWarResourceSet;
import org.joinfaces.tomcat.TomcatRuntime;
import org.reflections.util.ClasspathHelper;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class JsfTomcatApplicationListener
implements ApplicationListener<ApplicationReadyEvent> {
    private Context context;

    private JarWarResourceSet getFirstJarWarResourceSetAtJarResources(WebResourceRoot resources) {
        JarWarResourceSet result = null;
        for (WebResourceSet resourceSet : resources.getJarResources()) {
            if (!(resourceSet instanceof JarWarResourceSet)) continue;
            result = (JarWarResourceSet)resourceSet;
            break;
        }
        return result;
    }

    private DirResourceSet getFirstDirResourceSetAtJarResources(WebResourceRoot resources) {
        DirResourceSet result = null;
        for (WebResourceSet resourceSet : resources.getJarResources()) {
            if (!(resourceSet instanceof DirResourceSet)) continue;
            result = (DirResourceSet)resourceSet;
            break;
        }
        return result;
    }

    private URL mainFile(WebResourceRoot resources) {
        URL result = null;
        for (WebResourceSet resourceSet : resources.getJarResources()) {
            if (!(resourceSet instanceof JarWarResourceSet)) continue;
            result = resourceSet.getBaseUrl();
            break;
        }
        return result;
    }

    private String base(URL url) {
        String result;
        if (url.getProtocol().equals("jar")) {
            result = url.getFile();
            result = result.substring("file:".length());
            result = result.substring(0, result.indexOf("!/"));
        } else {
            result = url.getFile();
        }
        return result;
    }

    private boolean isUberJar(WebResourceRoot resources) {
        JarWarResourceSet jarWarResourceSet = this.getFirstJarWarResourceSetAtJarResources(resources);
        return jarWarResourceSet != null && jarWarResourceSet.getBaseUrl().getFile().endsWith(".jar");
    }

    private boolean isUberWar(WebResourceRoot resources) {
        JarWarResourceSet jarWarResourceSet = this.getFirstJarWarResourceSetAtJarResources(resources);
        return jarWarResourceSet != null && jarWarResourceSet.getBaseUrl().getFile().endsWith(".war");
    }

    private boolean isTesting(WebResourceRoot resources) {
        return !this.isUberJar(resources) && !this.isUberWar(resources) && this.getFirstDirResourceSetAtJarResources(resources) == null;
    }

    private boolean isUnpackagedJar(WebResourceRoot resources) {
        return !this.isUberJar(resources) && this.getFirstDirResourceSetAtJarResources(resources) != null;
    }

    TomcatRuntime getTomcatRuntime(WebResourceRoot resources) {
        TomcatRuntime result = null;
        if (this.isUberJar(resources)) {
            result = TomcatRuntime.UBER_JAR;
        } else if (this.isUberWar(resources)) {
            result = TomcatRuntime.UBER_WAR;
        } else if (this.isTesting(resources)) {
            result = TomcatRuntime.TEST;
        } else if (this.isUnpackagedJar(resources)) {
            result = TomcatRuntime.UNPACKAGED_JAR;
        }
        return result;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        WebResourceRoot resources;
        if (this.context != null && (resources = this.context.getResources()) != null && resources.getJarResources() != null) {
            TomcatRuntime tomcatRuntime = this.getTomcatRuntime(resources);
            switch (tomcatRuntime) {
                case UBER_JAR: {
                    this.addMainJarResourceSet(resources);
                    break;
                }
                case UNPACKAGED_JAR: {
                    break;
                }
                case UBER_WAR: {
                    break;
                }
                case TEST: {
                    this.addClasspathResourceSets(resources);
                    break;
                }
            }
        }
    }

    private void addMainJarResourceSet(WebResourceRoot resources) {
        String webAppMount = "/";
        String archivePath = null;
        String internalPath = "/META-INF/resources";
        resources.createWebResourceSet(WebResourceRoot.ResourceSetType.POST, webAppMount, this.base(this.mainFile(resources)), archivePath, internalPath);
    }

    private void addClasspathResourceSets(WebResourceRoot resources) {
        String webAppMount = "/";
        String archivePath = null;
        String internalPath = "/META-INF/resources";
        for (URL url : ClasspathHelper.forResource((String)"META-INF/resources/", (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()})) {
            resources.createWebResourceSet(WebResourceRoot.ResourceSetType.POST, webAppMount, this.base(url), archivePath, internalPath);
        }
    }

    @ConstructorProperties(value={"context"})
    @Generated
    JsfTomcatApplicationListener(Context context) {
        this.context = context;
    }

    @Generated
    public static JsfTomcatApplicationListenerBuilder builder() {
        return new JsfTomcatApplicationListenerBuilder();
    }

    @Generated
    public static class JsfTomcatApplicationListenerBuilder {
        @Generated
        private Context context;

        @Generated
        JsfTomcatApplicationListenerBuilder() {
        }

        @Generated
        public JsfTomcatApplicationListenerBuilder context(Context context) {
            this.context = context;
            return this;
        }

        @Generated
        public JsfTomcatApplicationListener build() {
            return new JsfTomcatApplicationListener(this.context);
        }

        @Generated
        public String toString() {
            return "JsfTomcatApplicationListener.JsfTomcatApplicationListenerBuilder(context=" + this.context + ")";
        }
    }
}

