/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.integration;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import org.joinfaces.integration.CustomScopeAnnotationConfigurer;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnClass(value={RequestScoped.class})
public class CdiScopeAnnotationsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"jsf.scope-configurer.cdi.enabled"}, havingValue="true", matchIfMissing=true)
    public static BeanFactoryPostProcessor cdiScopeAnnotationsConfigurer(Environment environment) {
        CustomScopeAnnotationConfigurer scopeAnnotationConfigurer = new CustomScopeAnnotationConfigurer();
        scopeAnnotationConfigurer.setOrder((Integer)environment.getProperty("jsf.scope-configurer.cdi.order", Integer.class, (Object)Integer.MAX_VALUE));
        scopeAnnotationConfigurer.addMapping(RequestScoped.class, "request");
        scopeAnnotationConfigurer.addMapping(SessionScoped.class, "session");
        scopeAnnotationConfigurer.addMapping(ConversationScoped.class, "session");
        scopeAnnotationConfigurer.addMapping(ApplicationScoped.class, "application");
        return scopeAnnotationConfigurer;
    }
}

