/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.windows;

import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import jogamp.nativewindow.ProxySurfaceImpl;
import jogamp.nativewindow.windows.GDI;

public class GDISurface
extends ProxySurfaceImpl {
    private long windowHandle;
    private long surfaceHandle;

    public GDISurface(AbstractGraphicsConfiguration abstractGraphicsConfiguration, long l, UpstreamSurfaceHook upstreamSurfaceHook, boolean bl) {
        super(abstractGraphicsConfiguration, upstreamSurfaceHook, bl);
        this.windowHandle = l;
        this.surfaceHandle = 0L;
    }

    protected void invalidateImpl() {
        if (0L != this.surfaceHandle) {
            throw new NativeWindowException("didn't release surface Handle: " + (Object)((Object)this));
        }
        this.windowHandle = 0L;
    }

    public final void setSurfaceHandle(long l) {
        this.windowHandle = l;
    }

    public final void setWindowHandle(long l) {
        this.windowHandle = l;
    }

    public final long getWindowHandle() {
        return this.windowHandle;
    }

    protected final int lockSurfaceImpl() {
        if (0L == this.windowHandle) {
            throw new NativeWindowException("null window handle: " + (Object)((Object)this));
        }
        if (0L != this.surfaceHandle) {
            throw new InternalError("surface not released");
        }
        this.surfaceHandle = GDI.GetDC(this.windowHandle);
        return 0L != this.surfaceHandle ? 3 : 1;
    }

    protected final void unlockSurfaceImpl() {
        if (0L != this.surfaceHandle) {
            if (0 == GDI.ReleaseDC(this.windowHandle, this.surfaceHandle)) {
                throw new NativeWindowException("DC not released: " + (Object)((Object)this) + ", isWindow " + GDI.IsWindow(this.windowHandle) + ", werr " + GDI.GetLastError() + ", thread: " + Thread.currentThread().getName());
            }
            this.surfaceHandle = 0L;
        }
    }

    public final long getSurfaceHandle() {
        return this.surfaceHandle;
    }

    public final int[] convertToWindowUnits(int[] nArray) {
        return nArray;
    }

    public final int[] convertToPixelUnits(int[] nArray) {
        return nArray;
    }
}

