/*
 * Decompiled with CFR 0.152.
 */
package org.jodreports.templates.xmlfilters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import org.jodreports.templates.DocumentTemplateException;
import org.jodreports.templates.xmlfilters.XmlEntryFilter;
import org.jodreports.templates.xmlfilters.tags.InsertAfterTag;
import org.jodreports.templates.xmlfilters.tags.InsertAroundTag;
import org.jodreports.templates.xmlfilters.tags.InsertBeforeTag;
import org.jodreports.templates.xmlfilters.tags.JooScriptTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptTagFilter
extends XmlEntryFilter {
    private static final Logger log = LoggerFactory.getLogger(ScriptTagFilter.class);
    private final Map<String, JooScriptTag> tags = new HashMap<String, JooScriptTag>();

    public ScriptTagFilter() {
        this.tags.put("insert-after", new InsertAfterTag());
        this.tags.put("insert-around", new InsertAroundTag());
        this.tags.put("insert-before", new InsertBeforeTag());
    }

    public void doFilter(Document document) throws DocumentTemplateException {
        Nodes scriptNodes = document.query("//text:script[translate(@script:language, 'CIJOPRST', 'cijoprst')='jooscript']", XPATH_CONTEXT);
        for (int nodeIndex = 0; nodeIndex < scriptNodes.size(); ++nodeIndex) {
            Element scriptElement = (Element)scriptNodes.get(nodeIndex);
            if (scriptElement.getValue().toLowerCase().startsWith("<jooscript>")) {
                Elements scriptTags = this.parseScriptText(scriptElement.getValue());
                for (int tagIndex = 0; tagIndex < scriptTags.size(); ++tagIndex) {
                    Element tagElement = scriptTags.get(tagIndex);
                    String tagName = tagElement.getLocalName();
                    if (this.tags.containsKey(tagName)) {
                        JooScriptTag tag = this.tags.get(tagName);
                        tag.process(scriptElement, tagElement);
                        continue;
                    }
                    log.error("unknown script tag: " + tagName + "; ignoring");
                }
                scriptElement.detach();
                continue;
            }
            try {
                String script = ScriptTagFilter.addScriptDirectives(scriptElement);
                scriptElement.getParent().replaceChild((Node)scriptElement, ScriptTagFilter.newNode(script));
                continue;
            }
            catch (IOException ioException) {
                log.error("unable to parse script: '" + scriptElement.getValue() + "'; ignoring", (Throwable)ioException);
                scriptElement.detach();
            }
        }
    }

    private Elements parseScriptText(String scriptText) throws DocumentTemplateException {
        Document document;
        new StringReader(scriptText);
        Builder builder = new Builder();
        StringReader reader = new StringReader(scriptText);
        try {
            document = builder.build((Reader)reader);
        }
        catch (Exception exception) {
            throw new DocumentTemplateException("invalid script: " + scriptText, exception);
        }
        reader.close();
        return document.getRootElement().getChildElements();
    }

    private static String addScriptDirectives(Element scriptElement) throws IOException, DocumentTemplateException {
        String scriptReplacement = "";
        List scriptParts = ScriptTagFilter.parseScriptParts(scriptElement.getValue());
        for (int index = 0; index < scriptParts.size(); ++index) {
            ScriptPart scriptPart = (ScriptPart)scriptParts.get(index);
            if (scriptPart.getLocation() == null) {
                scriptReplacement = scriptPart.getText();
                continue;
            }
            Element enclosingElement = ScriptTagFilter.findEnclosingElement(scriptElement, scriptPart.getLocation());
            if (scriptPart.isTagAttribute()) {
                String prefix;
                String[] nameValue = scriptPart.getText().split("=", 2);
                if (nameValue.length != 2) {
                    throw new DocumentTemplateException("script error: # attribute name=value not found");
                }
                String attributeNamespace = enclosingElement.getNamespaceURI();
                if (nameValue[0].contains(":") && !(prefix = nameValue[0].split(":")[0]).equals(enclosingElement.getNamespacePrefix()) && (attributeNamespace = XPATH_CONTEXT.lookup(prefix)) == null) {
                    throw new DocumentTemplateException("unsupported attribute namespace: " + prefix);
                }
                enclosingElement.addAttribute(new Attribute(nameValue[0], attributeNamespace, nameValue[1]));
                continue;
            }
            ParentNode parent = enclosingElement.getParent();
            int parentIndex = parent.indexOf((Node)enclosingElement);
            if (scriptPart.afterEndTag()) {
                ++parentIndex;
            }
            parent.insertChild(ScriptTagFilter.newNode(scriptPart.getText()), parentIndex);
        }
        return scriptReplacement;
    }

    private static List parseScriptParts(String scriptText) throws IOException, DocumentTemplateException {
        String line;
        ArrayList<ScriptPart> scriptParts = new ArrayList<ScriptPart>();
        BufferedReader stringReader = new BufferedReader(new StringReader(scriptText));
        ScriptPart scriptPart = new ScriptPart();
        scriptParts.add(scriptPart);
        while ((line = stringReader.readLine()) != null) {
            if ((line = line.trim()).startsWith("@")) {
                String location = line.substring(1);
                scriptPart = location.startsWith("/") ? new ScriptPart(location.substring(1), Boolean.TRUE) : (location.startsWith("#") ? new ScriptPart(location.substring(1), Boolean.FALSE) : new ScriptPart(location, null));
                scriptParts.add(scriptPart);
                continue;
            }
            scriptPart.appendText(line.replaceFirst("^\\[#--", "[#comment]").replaceFirst("--\\]$", "[/#comment]"));
        }
        return scriptParts;
    }

    private static Element findEnclosingElement(Element element, String enclosingTagName) throws DocumentTemplateException {
        Nodes ancestors = element.query("ancestor::" + enclosingTagName, XPATH_CONTEXT);
        if (ancestors.size() == 0 && (ancestors = element.query("preceding::" + enclosingTagName, XPATH_CONTEXT)).size() == 0) {
            throw new DocumentTemplateException("script error: no such enclosing tag named '" + enclosingTagName + "'");
        }
        return (Element)ancestors.get(ancestors.size() - 1);
    }

    private static class ScriptPart {
        private StringBuffer text = new StringBuffer();
        private String location;
        private Boolean isEndTag;

        public ScriptPart() {
        }

        public ScriptPart(String location, Boolean isEndTag) {
            this.location = location;
            this.isEndTag = isEndTag;
        }

        public void appendText(String line) {
            this.text.append(line + "\n");
        }

        public String getText() {
            return this.text.toString().trim();
        }

        public String getLocation() {
            return this.location;
        }

        public boolean afterEndTag() {
            boolean afterEndTag = false;
            if (this.isEndTag != null && this.isEndTag == Boolean.TRUE) {
                afterEndTag = true;
            }
            return afterEndTag;
        }

        public boolean isTagAttribute() {
            boolean insideTag = false;
            if (this.isEndTag != null && this.isEndTag == Boolean.FALSE) {
                insideTag = true;
            }
            return insideTag;
        }
    }
}

