/*
 * Decompiled with CFR 0.152.
 */
package org.jodreports.templates.xmlfilters;

import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Nodes;
import org.jodreports.opendocument.OpenDocumentNamespaces;
import org.jodreports.templates.xmlfilters.XmlEntryFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicImageFilter
extends XmlEntryFilter {
    public static final String IMAGE_NAME_PREFIX = "jooscript.image(";
    public static final String IMAGE_NAME_SUFFIX = ")";
    private static final String IMAGE_WIDTH_PREFIX = "jooscript.imageWidth(";
    private static final String IMAGE_HEIGHT_PREFIX = "jooscript.imageHeight(";
    private static final Logger log = LoggerFactory.getLogger(DynamicImageFilter.class);

    public void doFilter(Document document) {
        Nodes nodes = document.query("//draw:image", OpenDocumentNamespaces.XPATH_CONTEXT);
        for (int nodeIndex = 0; nodeIndex < nodes.size(); ++nodeIndex) {
            Element imageElement = (Element)nodes.get(nodeIndex);
            Element frameElement = (Element)imageElement.getParent();
            if (!"draw:frame".equals(frameElement.getQualifiedName())) {
                log.warn("draw:image not inside a draw:frame? skipping");
                continue;
            }
            String frameName = frameElement.getAttributeValue("name", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
            if (frameName == null || !frameName.toLowerCase().startsWith(IMAGE_NAME_PREFIX) || !frameName.endsWith(IMAGE_NAME_SUFFIX)) continue;
            Attribute hrefAttribute = imageElement.getAttribute("href", "http://www.w3.org/1999/xlink");
            String defaultImageName = hrefAttribute.getValue();
            if (frameName.contains(",")) {
                Attribute widthAttribute = frameElement.getAttribute("width", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
                Attribute heightAttribute = frameElement.getAttribute("height", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
                String maxSize = ",'" + widthAttribute.getValue().trim() + "','" + heightAttribute.getValue().trim() + "',";
                String sizeParameters = frameName.replaceFirst(",", maxSize);
                widthAttribute.setValue("${" + sizeParameters.replace(IMAGE_NAME_PREFIX, "jooscript.imageWidth('" + defaultImageName + "',") + "}");
                heightAttribute.setValue("${" + sizeParameters.replace(IMAGE_NAME_PREFIX, "jooscript.imageHeight('" + defaultImageName + "',") + "}");
                frameName = frameName.split(",")[0] + IMAGE_NAME_SUFFIX;
            }
            hrefAttribute.setValue("${" + frameName.replace(IMAGE_NAME_PREFIX, "jooscript.image('" + defaultImageName + "',") + "}");
        }
    }
}

