/*
 * Decompiled with CFR 0.152.
 */
package org.jodreports.templates;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jodreports.opendocument.OpenDocumentArchive;
import org.jodreports.templates.DocumentTemplate;
import org.jodreports.templates.DocumentTemplateException;
import org.jodreports.templates.xmlfilters.XmlEntryFilter;

class TemplatePreProcessor {
    private static final String UTF_8 = "UTF-8";
    private String[] xmlEntries;
    private XmlEntryFilter[] xmlEntryFilters;
    private DocumentTemplate.ContentWrapper contentWrapper;
    private final Map configurations;

    public TemplatePreProcessor(String[] xmlEntries, XmlEntryFilter[] xmlEntryFilters, DocumentTemplate.ContentWrapper contentWrapper, Map configurations) {
        this.xmlEntries = xmlEntries;
        this.xmlEntryFilters = xmlEntryFilters;
        this.contentWrapper = contentWrapper;
        this.configurations = configurations;
    }

    public void process(OpenDocumentArchive archive) throws DocumentTemplateException, IOException {
        for (String entryName : archive.getEntryNames()) {
            if (Arrays.binarySearch(this.xmlEntries, entryName) < 0) continue;
            InputStream inputStream = archive.getEntryInputStream(entryName);
            OutputStream outputStream = archive.getEntryOutputStream(entryName);
            this.applyXmlFilters(inputStream, outputStream);
            inputStream.close();
            outputStream.close();
        }
    }

    private void applyXmlFilters(InputStream input, OutputStream output) throws DocumentTemplateException, IOException {
        Builder builder = new Builder();
        Document document = null;
        try {
            document = builder.build(input);
        }
        catch (ParsingException parsingException) {
            throw new DocumentTemplateException(parsingException);
        }
        for (int i = 0; i < this.xmlEntryFilters.length; ++i) {
            this.xmlEntryFilters[i].applyConfigurations(this.configurations);
            this.xmlEntryFilters[i].doFilter(document);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Serializer serializer = new Serializer((OutputStream)byteArrayOutputStream, UTF_8);
        serializer.write(document);
        output.write(this.contentWrapper.wrapContent(byteArrayOutputStream.toString(UTF_8)).getBytes(UTF_8));
    }
}

