/*
 * Decompiled with CFR 0.152.
 */
package org.jodreports.templates;

import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jodreports.templates.Configuration;
import org.jodreports.templates.image.FileImageSource;
import org.jodreports.templates.image.ImageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class TemplateFreemarkerNamespace {
    public static final String NAME = "jooscript";
    private static final Logger log = LoggerFactory.getLogger(TemplateFreemarkerNamespace.class);
    private static final DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
    private boolean checkImageExistRequired = true;
    private int imageIndex = 0;
    private Map images = new HashMap();

    public TemplateFreemarkerNamespace() {
        decimalFormat.applyPattern("#.##");
    }

    public String getDoubleHyphen() {
        return "--";
    }

    public void applyConfigurations(Map configurations) {
        this.checkImageExistRequired = Configuration.getConfiguration("check_image_exist", configurations);
    }

    public String image(ImageSource imageWriter) {
        if (this.images.containsKey(imageWriter)) {
            return (String)this.images.get(imageWriter);
        }
        ++this.imageIndex;
        String imageHref = "Pictures/dynamic-image-" + this.imageIndex + ".png";
        this.images.put(imageWriter, imageHref);
        return imageHref;
    }

    public Map getImages() {
        return this.images;
    }

    public String image(String defaultImageName, ImageSource imageWriter) {
        return this.image(imageWriter);
    }

    public String image(String defaultImageName, String fileName) {
        if (this.imageExists(fileName)) {
            defaultImageName = this.image(new FileImageSource(fileName));
        }
        return defaultImageName;
    }

    public String image(String defaultImageName, Object object) {
        if (object instanceof String) {
            defaultImageName = this.image(defaultImageName, (String)object);
        } else if (object instanceof ImageSource) {
            defaultImageName = this.image((ImageSource)object);
        } else if (object instanceof Element) {
            defaultImageName = this.image(defaultImageName, ((Element)object).getTextContent());
        }
        return defaultImageName;
    }

    public String imageWidth(ImageSource imageSource, String maxWidthStr, String maxHeightStr, String format) {
        return this.getRatioDimension(imageSource.getWidth(), imageSource.getHeight(), maxWidthStr, maxHeightStr, true, format);
    }

    public String imageWidth(String defaultImageName, ImageSource imageSource, String maxWidth, String maxHeight, String format) {
        return this.imageWidth(imageSource, maxWidth, maxHeight, format);
    }

    public String imageWidth(String defaultImageName, String fileName, String maxWidth, String maxHeight, String format) {
        String result = maxWidth;
        if (this.imageExists(fileName)) {
            result = this.imageWidth(new FileImageSource(fileName), maxWidth, maxHeight, format);
        }
        return result;
    }

    public String imageWidth(String defaultImageName, Object object, String maxWidth, String maxHeight, String format) {
        String result = maxWidth;
        if (object instanceof String) {
            result = this.imageWidth(new FileImageSource((String)object), maxWidth, maxHeight, format);
        } else if (object instanceof ImageSource) {
            result = this.imageWidth((ImageSource)object, maxWidth, maxHeight, format);
        } else if (object instanceof Element) {
            result = this.imageWidth(new FileImageSource(((Element)object).getTextContent()), maxWidth, maxHeight, format);
        }
        return result;
    }

    public String imageHeight(ImageSource imageSource, String maxWidthStr, String maxHeightStr, String format) {
        return this.getRatioDimension(imageSource.getHeight(), imageSource.getWidth(), maxHeightStr, maxWidthStr, false, format);
    }

    public String imageHeight(String defaultImageName, ImageSource imageSource, String maxWidth, String maxHeight, String format) {
        return this.imageHeight(imageSource, maxWidth, maxHeight, format);
    }

    public String imageHeight(String defaultImageName, String fileName, String maxWidth, String maxHeight, String format) {
        String result = maxHeight;
        if (this.imageExists(fileName)) {
            result = this.imageHeight(new FileImageSource(fileName), maxWidth, maxHeight, format);
        }
        return result;
    }

    public String imageHeight(String defaultImageName, Object object, String maxWidth, String maxHeight, String format) {
        String result = maxHeight;
        if (object instanceof String) {
            result = this.imageHeight(new FileImageSource((String)object), maxWidth, maxHeight, format);
        } else if (object instanceof ImageSource) {
            result = this.imageHeight((ImageSource)object, maxWidth, maxHeight, format);
        } else if (object instanceof Element) {
            result = this.imageHeight(new FileImageSource(((Element)object).getTextContent()), maxWidth, maxHeight, format);
        }
        return result;
    }

    private String getRatioDimension(int dimX, int dimY, String maxDimXStr, String maxDimYStr, boolean isWidth, String format) {
        String result = maxDimXStr;
        if (dimX > 0 && dimY > 0 && maxDimXStr.length() > 2 && maxDimYStr.length() > 2) {
            String unit = maxDimXStr.substring(maxDimXStr.length() - 2);
            try {
                double maxDimX = Double.parseDouble(maxDimXStr.substring(0, maxDimXStr.length() - 2));
                double maxDimY = Double.parseDouble(maxDimYStr.substring(0, maxDimYStr.length() - 2));
                double maxRatio = maxDimX / maxDimY;
                double ratio = (double)dimX / (double)dimY;
                if (ratio != 0.0 && format.equalsIgnoreCase("Max" + (isWidth ? "Height" : "Width")) || format.equalsIgnoreCase("fit") && ratio < maxRatio) {
                    result = decimalFormat.format(maxDimY * ratio) + unit;
                }
            }
            catch (NumberFormatException nfException) {
                log.error("Cannot get image dimension", (Throwable)nfException);
            }
            catch (ArithmeticException aException) {
                log.error("Cannot divide by 0", (Throwable)aException);
            }
        }
        return result;
    }

    private boolean imageExists(String fileName) {
        boolean isFileExist = true;
        if (this.checkImageExistRequired) {
            isFileExist = new File(fileName).exists();
        }
        return isFileExist;
    }
}

