/*
 * Decompiled with CFR 0.152.
 */
package org.jodreports.templates;

import freemarker.core.Environment;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jodreports.opendocument.ManifestSubDocument;
import org.jodreports.opendocument.OpenDocumentArchive;
import org.jodreports.opendocument.SettingsSubDocument;
import org.jodreports.templates.DocumentTemplateException;
import org.jodreports.templates.TemplateFreemarkerNamespace;
import org.jodreports.templates.image.ImageSource;

class TemplateAndModelMerger {
    private final Configuration freemarkerConfiguration;
    private final String[] xmlEntries;
    private final Map openDocumentSettings;
    private final Map configurations;

    public TemplateAndModelMerger(Configuration freemarkerConfiguration, String[] xmlEntries, Map openDocumentSettings, Map configurations) {
        this.freemarkerConfiguration = freemarkerConfiguration;
        this.xmlEntries = xmlEntries;
        this.openDocumentSettings = openDocumentSettings;
        this.configurations = configurations;
    }

    public void process(OpenDocumentArchive archive, Object model) throws IOException, DocumentTemplateException {
        TemplateFreemarkerNamespace predefinedNamespace = new TemplateFreemarkerNamespace();
        predefinedNamespace.applyConfigurations(this.configurations);
        for (String entryName : archive.getEntryNames()) {
            if (Arrays.binarySearch(this.xmlEntries, entryName) < 0) continue;
            Reader reader = archive.getEntryReader(entryName);
            Writer writer = archive.getEntryWriter(entryName);
            Template template = new Template(entryName, reader, this.freemarkerConfiguration);
            BeansWrapper beansWrapper = new BeansWrapper();
            try {
                Environment environment = template.createProcessingEnvironment(model, writer);
                environment.setGlobalVariable("jooscript", beansWrapper.wrap((Object)predefinedNamespace));
                environment.process();
            }
            catch (TemplateException templateException) {
                throw new DocumentTemplateException(templateException);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Writer)writer);
            }
        }
        if (!predefinedNamespace.getImages().isEmpty()) {
            this.addRequiredImages(archive, predefinedNamespace.getImages());
        }
        if (this.openDocumentSettings.size() > 0) {
            this.changeOpenDocumentSettings(archive);
        }
    }

    private void addRequiredImages(OpenDocumentArchive archive, Map images) throws IOException {
        InputStream inputStream = archive.getEntryInputStream("META-INF/manifest.xml");
        ManifestSubDocument manifest = new ManifestSubDocument(inputStream);
        inputStream.close();
        for (ImageSource imageWriter : images.keySet()) {
            String imageHref = (String)images.get(imageWriter);
            OutputStream imageOutputStream = archive.getEntryOutputStream(imageHref);
            imageWriter.write(imageOutputStream);
            IOUtils.closeQuietly((OutputStream)imageOutputStream);
            manifest.addFileEntry("image/png", imageHref);
        }
        OutputStream outputStream = archive.getEntryOutputStream("META-INF/manifest.xml");
        manifest.save(outputStream);
        outputStream.close();
    }

    private void changeOpenDocumentSettings(OpenDocumentArchive archive) throws IOException {
        InputStream inputStream = archive.getEntryInputStream("settings.xml");
        SettingsSubDocument settings = new SettingsSubDocument(inputStream);
        inputStream.close();
        settings.changeSettings(this.openDocumentSettings);
        OutputStream outputStream = archive.getEntryOutputStream("settings.xml");
        settings.save(outputStream);
        outputStream.close();
    }
}

