/*
 * Decompiled with CFR 0.152.
 */
package org.jodreports.templates;

import freemarker.template.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jodreports.opendocument.OpenDocumentIO;
import org.jodreports.templates.DocumentTemplate;
import org.jodreports.templates.UnzippedDocumentTemplate;
import org.jodreports.templates.ZippedDocumentTemplate;

public class DocumentTemplateFactory {
    private final Configuration freemarkerConfiguration = new Configuration();

    public DocumentTemplateFactory() {
        this.freemarkerConfiguration.setTagSyntax(2);
        this.freemarkerConfiguration.setDefaultEncoding(OpenDocumentIO.UTF_8.name());
        this.freemarkerConfiguration.setOutputEncoding(OpenDocumentIO.UTF_8.name());
    }

    public Configuration getFreemarkerConfiguration() {
        return this.freemarkerConfiguration;
    }

    public DocumentTemplate getTemplate(File file) throws IOException {
        if (file.isDirectory()) {
            return new UnzippedDocumentTemplate(file, this.freemarkerConfiguration);
        }
        return this.getTemplate(new FileInputStream(file));
    }

    public DocumentTemplate getTemplate(InputStream inputStream) throws IOException {
        return new ZippedDocumentTemplate(inputStream, this.freemarkerConfiguration);
    }
}

