/*
 * Decompiled with CFR 0.152.
 */
package org.jodreports.templates;

import freemarker.template.Configuration;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jodreports.opendocument.OpenDocumentArchive;
import org.jodreports.opendocument.OpenDocumentIO;
import org.jodreports.templates.DocumentTemplate;
import org.jodreports.templates.DocumentTemplateException;
import org.jodreports.templates.TemplateAndModelMerger;
import org.jodreports.templates.TemplatePreProcessor;
import org.jodreports.templates.xmlfilters.DynamicImageFilter;
import org.jodreports.templates.xmlfilters.ScriptTagFilter;
import org.jodreports.templates.xmlfilters.TextInputTagFilter;
import org.jodreports.templates.xmlfilters.XmlEntryFilter;

public abstract class AbstractDocumentTemplate
implements DocumentTemplate {
    private static final Configuration DEFAULT_FREEMARKER_CONFIGURATION = new Configuration();
    private static final DocumentTemplate.ContentWrapper DEFAULT_CONTENT_WRAPPER = new DocumentTemplate.ContentWrapper(){

        public String wrapContent(String content) {
            return "[#ftl]\n[#escape any as any?xml?replace(\"\\n\",\"<text:line-break />\")]\n" + content + "[/#escape]";
        }
    };
    private static final XmlEntryFilter[] DEFAULT_XML_ENTRY_FILTERS = new XmlEntryFilter[]{new TextInputTagFilter(), new ScriptTagFilter(), new DynamicImageFilter()};
    private final Configuration freemarkerConfiguration;
    private DocumentTemplate.ContentWrapper contentWrapper = DEFAULT_CONTENT_WRAPPER;
    private XmlEntryFilter[] xmlEntryFilters = DEFAULT_XML_ENTRY_FILTERS;
    private String[] xmlEntries = new String[]{"content.xml", "styles.xml"};
    private OpenDocumentArchive preProcessedTemplate;
    private Map openDocumentSettings = new HashMap();
    private Map configurations = new HashMap();

    public AbstractDocumentTemplate() {
        this(DEFAULT_FREEMARKER_CONFIGURATION);
    }

    public AbstractDocumentTemplate(Configuration freemarkerConfiguration) {
        this.freemarkerConfiguration = freemarkerConfiguration;
    }

    public void setXmlEntries(String[] xmlEntries) {
        this.xmlEntries = xmlEntries;
        Arrays.sort(this.xmlEntries);
    }

    public void setXmlEntryFilters(XmlEntryFilter[] xmlEntryFilters) {
        this.xmlEntryFilters = xmlEntryFilters;
    }

    public void setContentWrapper(DocumentTemplate.ContentWrapper contentWrapper) {
        this.contentWrapper = contentWrapper;
    }

    protected abstract OpenDocumentArchive getOpenDocumentArchive();

    public void setOpenDocumentSettings(Map openDocumentSettings) {
        this.openDocumentSettings = openDocumentSettings;
    }

    public void createDocument(Object model, OutputStream output) throws IOException, DocumentTemplateException {
        if (this.preProcessedTemplate == null) {
            this.preProcess();
        }
        OpenDocumentArchive outputArchive = this.preProcessedTemplate.createCopy();
        TemplateAndModelMerger templateAndModelMerger = new TemplateAndModelMerger(this.freemarkerConfiguration, this.xmlEntries, this.openDocumentSettings, this.configurations);
        templateAndModelMerger.process(outputArchive, model);
        OpenDocumentIO.writeZip(outputArchive, output);
    }

    private void preProcess() throws IOException, DocumentTemplateException {
        this.preProcessedTemplate = this.getOpenDocumentArchive();
        TemplatePreProcessor templatePreProcessor = new TemplatePreProcessor(this.xmlEntries, this.xmlEntryFilters, this.contentWrapper, this.configurations);
        templatePreProcessor.process(this.preProcessedTemplate);
    }

    public Map getConfigurations() {
        return this.configurations;
    }
}

