/*
 * Decompiled with CFR 0.152.
 */
package org.jodreports.opendocument;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jodreports.opendocument.OpenDocumentIO;

public class OpenDocumentArchive {
    public static final String ENTRY_MIMETYPE = "mimetype";
    public static final String ENTRY_STYLES = "styles.xml";
    public static final String ENTRY_CONTENT = "content.xml";
    public static final String ENTRY_MANIFEST = "META-INF/manifest.xml";
    public static final String ENTRY_SETTINGS = "settings.xml";
    private Map entries = new LinkedHashMap();

    public Set getEntryNames() {
        return this.entries.keySet();
    }

    public InputStream getEntryInputStream(String entryName) {
        return new ByteArrayInputStream((byte[])this.entries.get(entryName));
    }

    public Reader getEntryReader(String entryName) {
        return OpenDocumentIO.toUtf8Reader(this.getEntryInputStream(entryName));
    }

    public OutputStream getEntryOutputStream(String entryName) {
        return new EntryByteArrayOutputStream(entryName);
    }

    public Writer getEntryWriter(String entryName) {
        return OpenDocumentIO.toUtf8Writer(this.getEntryOutputStream(entryName));
    }

    public OpenDocumentArchive createCopy() {
        OpenDocumentArchive archiveCopy = new OpenDocumentArchive();
        for (Map.Entry entry : this.entries.entrySet()) {
            String name = (String)entry.getKey();
            byte[] entryData = (byte[])entry.getValue();
            byte[] entryDataCopy = new byte[entryData.length];
            System.arraycopy(entryData, 0, entryDataCopy, 0, entryData.length);
            archiveCopy.entries.put(name, entryDataCopy);
        }
        return archiveCopy;
    }

    private class EntryByteArrayOutputStream
    extends ByteArrayOutputStream {
        private String entryName;

        public EntryByteArrayOutputStream(String entryName) {
            this.entryName = entryName;
        }

        public void close() throws IOException {
            OpenDocumentArchive.this.entries.put(this.entryName, this.toByteArray());
        }
    }
}

