/*
 * Decompiled with CFR 0.152.
 */
package org.jodreports.opendocument;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.jodreports.opendocument.OpenDocumentIO;

public class ManifestSubDocument {
    private Document document;

    public ManifestSubDocument(InputStream inputStream) throws IOException {
        Builder builder = new Builder();
        try {
            this.document = builder.build(inputStream);
        }
        catch (ParsingException parsingException) {
            throw new IllegalArgumentException("inputStream contains invalid XML: " + parsingException.getMessage());
        }
    }

    public void addFileEntry(String mediaType, String fullPath) {
        Element manifest = this.document.getRootElement();
        Element fileEntry = new Element("manifest:file-entry", "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0");
        fileEntry.addAttribute(new Attribute("manifest:media-type", "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", mediaType));
        fileEntry.addAttribute(new Attribute("manifest:full-path", "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", fullPath));
        manifest.appendChild((Node)fileEntry);
    }

    public void save(OutputStream outputStream) throws IOException {
        Serializer serializer = new Serializer(outputStream, OpenDocumentIO.UTF_8.name());
        serializer.setIndent(1);
        serializer.write(this.document);
    }
}

