/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.util.ArrayList;
import jodd.asm.AnnotationVisitorAdapter;
import jodd.asm.EmptyClassVisitor;
import jodd.proxetta.ProxyAspect;
import jodd.proxetta.asm.MethodSignatureVisitor;
import jodd.proxetta.asm.ProxettaCtorBuilder;
import jodd.proxetta.asm.ProxettaMethodBuilder;
import jodd.proxetta.asm.ProxyAspectData;
import jodd.proxetta.asm.TargetClassInfoReader;
import jodd.proxetta.asm.WorkData;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ProxettaClassBuilder
extends EmptyClassVisitor {
    protected final ProxyAspect[] aspects;
    protected final String suffix;
    protected final String reqProxyClassName;
    protected final TargetClassInfoReader targetClassInfo;
    protected final WorkData wd;

    public ProxettaClassBuilder(ClassVisitor dest, ProxyAspect[] aspects, String suffix, String reqProxyClassName, TargetClassInfoReader targetClassInfoReader) {
        this.wd = new WorkData(dest);
        this.aspects = aspects;
        this.suffix = suffix;
        this.reqProxyClassName = reqProxyClassName;
        this.targetClassInfo = targetClassInfoReader;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.wd.init(name, superName, this.suffix, this.reqProxyClassName);
        this.wd.dest.visit(version, access &= 0xFFFFFBFF, this.wd.thisReference, signature, this.wd.superName, null);
        this.wd.proxyAspects = new ProxyAspectData[this.aspects.length];
        for (int i = 0; i < this.aspects.length; ++i) {
            this.wd.proxyAspects[i] = new ProxyAspectData(this.wd, this.aspects[i], i);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodSignatureVisitor msign = this.targetClassInfo.lookupMethodSignatureVisitor(access, name, desc, this.wd.superReference);
        if (msign == null) {
            return null;
        }
        if (name.equals("<init>")) {
            MethodVisitor mv = this.wd.dest.visitMethod(access, name, desc, msign.getSignature(), null);
            return new ProxettaCtorBuilder(mv, msign, this.wd);
        }
        if (name.equals("<clinit>")) {
            return null;
        }
        return this.applyProxy(msign);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor destAnn = this.wd.dest.visitAnnotation(desc, visible);
        return new AnnotationVisitorAdapter(destAnn);
    }

    public void visitEnd() {
        MethodVisitor mv;
        if (this.wd.adviceClinits != null) {
            mv = this.wd.dest.visitMethod(8, "<clinit>", "()V", null, null);
            mv.visitCode();
            for (String name : this.wd.adviceClinits) {
                mv.visitMethodInsn(184, this.wd.thisReference, name, "()V");
            }
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        mv = this.wd.dest.visitMethod(18, "$init", "()V", null, null);
        mv.visitCode();
        if (this.wd.adviceInits != null) {
            for (String name : this.wd.adviceInits) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, this.wd.thisReference, name, "()V");
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        for (ClassReader cr : this.targetClassInfo.superClassReaders) {
            cr.accept((ClassVisitor)new EmptyClassVisitor(){
                String declaredClassName;

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    this.declaredClassName = name;
                }

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    if (name.equals("<init>") || name.equals("<clinit>")) {
                        return null;
                    }
                    MethodSignatureVisitor msign = ProxettaClassBuilder.this.targetClassInfo.lookupMethodSignatureVisitor(access, name, desc, this.declaredClassName);
                    if (msign == null) {
                        return null;
                    }
                    return ProxettaClassBuilder.this.applyProxy(msign);
                }
            }, 0);
        }
        this.wd.dest.visitEnd();
    }

    public void visitSource(String source, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    protected ProxettaMethodBuilder applyProxy(MethodSignatureVisitor msign) {
        ArrayList<ProxyAspectData> aspectList = null;
        for (ProxyAspectData aspectData : this.wd.proxyAspects) {
            if (!aspectData.apply(msign)) continue;
            if (aspectList == null) {
                aspectList = new ArrayList<ProxyAspectData>(this.wd.proxyAspects.length);
            }
            aspectList.add(aspectData);
        }
        if (aspectList == null) {
            return null;
        }
        this.wd.proxyApplied = true;
        return new ProxettaMethodBuilder(msign, this.wd, aspectList);
    }
}

