/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jodd.madvoc.ScopeType;
import jodd.madvoc.injector.BaseScopeInjector;
import jodd.madvoc.injector.ScopeData;

public class SessionScopeInjector
extends BaseScopeInjector {
    public SessionScopeInjector() {
        super(ScopeType.SESSION);
    }

    public void inject(Object target, HttpServletRequest servletRequest) {
        ScopeData.In[] injectData = this.lookupInData(target.getClass());
        if (injectData == null) {
            return;
        }
        HttpSession session = servletRequest.getSession();
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attrName = (String)attributeNames.nextElement();
            for (ScopeData.In in : injectData) {
                String name = this.getMatchedPropertyName(in, attrName);
                if (name == null) continue;
                Object attrValue = session.getAttribute(attrName);
                this.setTargetProperty(target, name, attrValue, in.create);
                if (!in.remove) continue;
                session.removeAttribute(attrName);
            }
        }
    }

    public void outject(Object target, HttpServletRequest servletRequest) {
        ScopeData.Out[] outjectData = this.lookupOutData(target.getClass());
        if (outjectData == null) {
            return;
        }
        HttpSession session = servletRequest.getSession();
        for (ScopeData.Out out : outjectData) {
            Object value = this.getTargetProperty(target, out);
            session.setAttribute(out.name, value);
        }
    }
}

