/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import jodd.madvoc.ActionConfig;
import jodd.madvoc.MadvocUtil;
import jodd.madvoc.component.MadvocConfig;
import jodd.petite.meta.PetiteInject;
import jodd.util.StringUtil;

public class ResultMapper {
    protected static final String REPL_CLASS = "[class]";
    protected static final String REPL_METHOD = "[method]";
    @PetiteInject
    protected MadvocConfig madvocConfig;

    protected String resolveAlias(String resultValue) {
        StringBuilder result = new StringBuilder(resultValue.length());
        int i = 0;
        int len = resultValue.length();
        while (i < len) {
            int ndx = resultValue.indexOf(37, i);
            if (ndx == -1) {
                resultValue = i == 0 ? resultValue : resultValue.substring(i);
                String alias = this.madvocConfig.lookupPathAlias(resultValue);
                result.append(alias != null ? alias : resultValue);
                break;
            }
            result.append(resultValue.substring(i, ndx));
            int ndx2 = resultValue.indexOf(37, ++ndx);
            String alias = ndx2 == -1 ? resultValue.substring(ndx) : resultValue.substring(ndx, ndx2);
            alias = this.madvocConfig.lookupPathAlias(alias);
            if (alias != null) {
                result.append(alias);
            }
            i = ndx2 + 1;
        }
        len = result.length();
        for (i = 0; i < len && result.charAt(i) == '/'; ++i) {
        }
        if (i > 1) {
            return ((Object)result.subSequence(i - 1, len)).toString();
        }
        return result.toString();
    }

    public String resolveResultPath(ActionConfig cfg, String resultValue) {
        int dotNdx;
        boolean strip;
        boolean aliasResolved = false;
        if (resultValue != null) {
            if (resultValue.indexOf(91) != -1) {
                String name = cfg.actionClass.getSimpleName();
                name = StringUtil.uncapitalize((String)name);
                name = MadvocUtil.stripLastCamelWord(name);
                resultValue = StringUtil.replace((String)resultValue, (String)REPL_CLASS, (String)name);
                resultValue = StringUtil.replace((String)resultValue, (String)REPL_METHOD, (String)cfg.actionClassMethod.getName());
            }
            resultValue = this.resolveAlias(resultValue);
            aliasResolved = true;
            if (resultValue.startsWith("/")) {
                return resultValue;
            }
        }
        String resultPath = cfg.actionPath;
        boolean bl = strip = cfg.getActionPathExtension() != null;
        if (strip && this.madvocConfig.strictExtensionStripForResultPath && !cfg.isPathEndsWithExtension()) {
            strip = false;
        }
        if (strip && resultValue != null && StringUtil.startsWithChar((String)resultValue, (char)'.')) {
            strip = false;
        }
        if (strip && (dotNdx = MadvocUtil.lastIndexOfDotAfterSlash(resultPath)) != -1) {
            resultPath = resultPath.substring(0, dotNdx);
        }
        boolean addDot = true;
        if (resultValue != null) {
            int i;
            for (i = 0; i < resultValue.length() && resultValue.charAt(i) == '#'; ++i) {
                int dotNdx2 = MadvocUtil.lastIndexOfSlashDot(resultPath);
                if (dotNdx2 == -1 || (resultPath = resultPath.substring(0, dotNdx2)).charAt(dotNdx2 - 1) != '/') continue;
                addDot = false;
            }
            if (i > 0) {
                resultValue = resultValue.substring(i);
            }
            if (StringUtil.startsWithChar((String)resultValue, (char)'.')) {
                if (resultValue.length() > 1) {
                    addDot = false;
                } else {
                    resultValue = "";
                }
            }
        }
        if (resultValue != null && resultValue.length() != 0) {
            if (addDot) {
                resultPath = resultPath + ".";
            }
            resultPath = resultPath + resultValue;
        }
        if (!aliasResolved) {
            resultPath = this.resolveAlias(resultPath);
        }
        return resultPath;
    }
}

