/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.exception.ExceptionUtil;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.MadvocUtil;
import jodd.madvoc.interceptor.ActionInterceptor;

public class ActionRequest {
    protected final ActionConfig config;
    protected final String actionPath;
    protected final String[] actionPathChunks;
    protected HttpServletRequest servletRequest;
    protected HttpServletResponse servletResponse;
    protected Object[] params;
    protected final int totalInterceptors;
    protected int interceptorIndex;
    protected Object action;
    protected boolean executed;
    protected String nextActionPath;
    protected ActionRequest previousActionRequest;

    public HttpServletRequest getHttpServletRequest() {
        return this.servletRequest;
    }

    public void setHttpServletRequest(HttpServletRequest request) {
        this.servletRequest = request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.servletResponse;
    }

    public void setHttpServletResponse(HttpServletResponse response) {
        this.servletResponse = response;
    }

    public ActionConfig getActionConfig() {
        return this.config;
    }

    public Object getAction() {
        return this.action;
    }

    public String getActionPath() {
        return this.actionPath;
    }

    public String[] getActionPathChunks() {
        return this.actionPathChunks;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public String getNextActionPath() {
        return this.nextActionPath;
    }

    public void setNextActionPath(String nextActionPath) {
        this.nextActionPath = nextActionPath;
    }

    public ActionRequest getPreviousActionRequest() {
        return this.previousActionRequest;
    }

    public void setPreviousActionRequest(ActionRequest previousActionRequest) {
        this.previousActionRequest = previousActionRequest;
    }

    public void setActionParams(Object[] params) {
        this.params = params;
    }

    public ActionRequest(String actionPath, ActionConfig config, Object action, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.actionPath = actionPath;
        this.actionPathChunks = MadvocUtil.splitActionPath(actionPath);
        this.config = config;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.totalInterceptors = this.config.interceptors != null ? this.config.interceptors.length : 0;
        this.interceptorIndex = 0;
        this.action = action;
    }

    public Object invoke() throws Exception {
        if (this.executed) {
            throw new MadvocException("Action '" + this.config.actionPath + "' has already been invoked.");
        }
        if (this.interceptorIndex < this.totalInterceptors) {
            ActionInterceptor interceptor = this.config.interceptors[this.interceptorIndex];
            ++this.interceptorIndex;
            return interceptor.intercept(this);
        }
        Object actionInvocationResult = this.invokeAction();
        this.executed = true;
        return actionInvocationResult;
    }

    protected Object invokeAction() throws Exception {
        try {
            return this.config.actionClassMethod.invoke(this.action, this.params);
        }
        catch (InvocationTargetException itex) {
            throw ExceptionUtil.extractTargetException((InvocationTargetException)itex);
        }
    }
}

