/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.io.IOException;
import jodd.lagarto.TagWriterUtil;
import jodd.lagarto.dom.Node;

public class Comment
extends Node {
    protected final Boolean conditionalDownlevelHidden;
    protected final boolean isStartingTag;

    public Comment(String comment) {
        super(Node.NodeType.COMMENT, null, true);
        this.nodeValue = comment;
        this.conditionalDownlevelHidden = null;
        this.isStartingTag = false;
    }

    public Comment(String comment, boolean isStartingTag, boolean conditionalDownlevelHidden) {
        super(Node.NodeType.COMMENT, null, true);
        this.nodeValue = comment;
        this.isStartingTag = isStartingTag;
        this.conditionalDownlevelHidden = conditionalDownlevelHidden;
    }

    public Comment clone() {
        return this.cloneTo(this.conditionalDownlevelHidden == null ? new Comment(this.nodeValue) : new Comment(this.nodeValue, this.isStartingTag, (boolean)this.conditionalDownlevelHidden));
    }

    public boolean isConditionalComment() {
        return this.conditionalDownlevelHidden != null;
    }

    public boolean isDownlevelHidden() {
        if (this.conditionalDownlevelHidden == null) {
            return false;
        }
        return this.conditionalDownlevelHidden;
    }

    public void toHtml(Appendable appendable) throws IOException {
        if (this.conditionalDownlevelHidden == null) {
            TagWriterUtil.writeComment(appendable, this.nodeValue);
        } else {
            TagWriterUtil.writeConditionalComment(appendable, this.nodeValue, this.isStartingTag, this.conditionalDownlevelHidden);
        }
    }
}

