/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.csselly;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.LinkedList;
import jodd.lagarto.csselly.CSSellyException;
import jodd.lagarto.csselly.Combinator;
import jodd.lagarto.csselly.CssSelector;

final class CSSellyLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 4096;
    public static final int COMBINATOR = 6;
    public static final int YYINITIAL = 0;
    public static final int ATTR = 4;
    public static final int SELECTOR = 2;
    public static final int PSEUDO_FN = 8;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4};
    private static final String ZZ_CMAP_PACKED = "\t\u0002\u0001\b\u0001\u0007\u0001\u0002\u0001\t\u0001\u0006\u0012\u0002\u0001\b\u0001\u0002\u0001\u000b\u0001\u000f\u0001\u0014\u0002\u0002\u0001\f\u0001\u0011\u0001\"\u0001\r\u0001\u0017\u0001\u0002\u0001\u0001\u0001\n\u0001\u0002\n\u0005\u0001\u0010\u0002\u0002\u0001\u0012\u0001\u0016\u0005\u0002\u0001\u001c\u0001\u001e\b\u0002\u0001\u0019\u0001\u001b\u0006\u0002\u0001!\u0004\u0002\u0001\u000e\u0001\u0003\u0001\u0015\u0001\u0014\u0001\u0000\u0001\u0002\u0003\u0004\u0001\u001d\u0001\u001f\u0001\u0004\u0007\u0000\u0001\u0018\u0001\u001a\u0006\u0000\u0001 \u0004\u0000\u0001\u0002\u0001\u0014\u0001\u0002\u0001\u0013\u0001\u0002\uff80\u0000";
    private static final char[] ZZ_CMAP = CSSellyLexer.zzUnpackCMap("\t\u0002\u0001\b\u0001\u0007\u0001\u0002\u0001\t\u0001\u0006\u0012\u0002\u0001\b\u0001\u0002\u0001\u000b\u0001\u000f\u0001\u0014\u0002\u0002\u0001\f\u0001\u0011\u0001\"\u0001\r\u0001\u0017\u0001\u0002\u0001\u0001\u0001\n\u0001\u0002\n\u0005\u0001\u0010\u0002\u0002\u0001\u0012\u0001\u0016\u0005\u0002\u0001\u001c\u0001\u001e\b\u0002\u0001\u0019\u0001\u001b\u0006\u0002\u0001!\u0004\u0002\u0001\u000e\u0001\u0003\u0001\u0015\u0001\u0014\u0001\u0000\u0001\u0002\u0003\u0004\u0001\u001d\u0001\u001f\u0001\u0004\u0007\u0000\u0001\u0018\u0001\u001a\u0006\u0000\u0001 \u0004\u0000\u0001\u0002\u0001\u0014\u0001\u0002\u0001\u0013\u0001\u0002\uff80\u0000");
    private static final int[] ZZ_ACTION = CSSellyLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0001\u0001\u0002\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0004\u0003\u0005\u0001\u0001\u0001\u0006\u0001\u0002\u0001\u0007\u0001\u0002\u0001\b\u0002\u0002\u0001\t\u0003\u0007\u0001\n\u0001\u000b\u0001\u0003\u0001\f\u0001\r\u0001\u000e\u0006\u0007\u0001\u0000\u0001\u0004\u0001\u000f\u0002\u0000\u0001\u0010\u0001\u0000\u0001\u0011\u0003\u0000\u0001\t\u0002\u0000\u0001\t\u0005\u0000\u0001\u0012\u0007\u0000\u0002\u0004\u0001\u000f\u0001\u0010\u0001\u0013\u0001\u0011\u0001\t\u0004\u0000\u0002\t\u0002\u0000\u0001\u0004\u0002\u000f\u0002\u0010\u0002\u0011\u0002\t\u0002\u0000\u0001\t\u0001\u0004\u0001\u000f\u0001\u0010\u0001\u0011\u0002\t\u0002\u0000\u0001\t\u0002\u0000\u0002\t\u0001\u0004\u0001\u000f\u0001\u0010\u0001\u0011\u0001\t\u0002\u0000\u0001\t\u0001\u0004\u0001\u000f\u0001\u0010\u0001\u0011\u0001\t\u0002\u0000\u0001\t\u0001\u000f\u0001\u0010\u0001\u0011\u0001\t\u0002\u0000\u0001\t\u0004\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[4096];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    LinkedList<CssSelector> selectors = new LinkedList();
    CssSelector cssSelector;
    String pseudoFnName;

    private static int[] zzUnpackAction() {
        int[] result = new int[128];
        int offset = 0;
        offset = CSSellyLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public int position() {
        return this.yychar;
    }

    public int length() {
        return this.yylength();
    }

    public int line() {
        return -1;
    }

    public int column() {
        return -1;
    }

    public void stateReset() {
        this.yybegin(0);
    }

    public void stateSelector() {
        this.yybegin(2);
    }

    public void stateAttr() {
        this.yybegin(4);
    }

    public void stateCombinator() {
        this.yybegin(6);
    }

    public void statePseudoFn() {
        this.yybegin(8);
    }

    public final CharSequence xxtext() {
        return CharBuffer.wrap(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final String yytext(int startIndex) {
        return new String(this.zzBuffer, startIndex += this.zzStartRead, this.zzMarkedPos - startIndex);
    }

    public final String yytext(int startIndex, int endIndexOffset) {
        return new String(this.zzBuffer, startIndex += this.zzStartRead, this.zzMarkedPos - endIndexOffset - startIndex);
    }

    CSSellyLexer(Reader in) {
        this.zzReader = in;
    }

    CSSellyLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 116) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() throws IOException {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
            this.yyclose();
        }
    }

    public int yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        block792: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            block793: while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                zzInput = zzCMapL[zzInput];
                boolean zzIsFinal = false;
                boolean zzNoLookAhead = false;
                block0 : switch (this.zzState) {
                    case 0: {
                        switch (zzInput) {
                            case 0: 
                            case 4: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 5;
                                break block0;
                            }
                            case 1: {
                                zzIsFinal = true;
                                this.zzState = 6;
                                break block0;
                            }
                            case 3: {
                                zzIsFinal = true;
                                this.zzState = 8;
                                break block0;
                            }
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                this.zzState = 9;
                                break block0;
                            }
                            case 13: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 10;
                                break block0;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 7;
                        break;
                    }
                    case 1: {
                        switch (zzInput) {
                            case 7: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 12;
                                break block0;
                            }
                            case 10: {
                                zzIsFinal = true;
                                this.zzState = 13;
                                break block0;
                            }
                            case 14: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 14;
                                break block0;
                            }
                            case 15: {
                                zzIsFinal = true;
                                this.zzState = 15;
                                break block0;
                            }
                            case 16: {
                                zzIsFinal = true;
                                this.zzState = 16;
                                break block0;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 11;
                        break;
                    }
                    case 2: {
                        switch (zzInput) {
                            case 0: 
                            case 4: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break block0;
                            }
                            case 1: {
                                zzIsFinal = true;
                                this.zzState = 18;
                                break block0;
                            }
                            case 3: {
                                zzIsFinal = true;
                                this.zzState = 19;
                                break block0;
                            }
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                this.zzState = 20;
                                break block0;
                            }
                            case 21: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 21;
                                break block0;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 12;
                        break;
                    }
                    case 3: {
                        switch (zzInput) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                this.zzState = 23;
                                break block0;
                            }
                            case 19: {
                                zzIsFinal = true;
                                this.zzState = 24;
                                break block0;
                            }
                            case 22: {
                                zzIsFinal = true;
                                this.zzState = 25;
                                break block0;
                            }
                            case 23: {
                                zzIsFinal = true;
                                this.zzState = 26;
                                break block0;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 22;
                        break;
                    }
                    case 4: {
                        switch (zzInput) {
                            case 1: 
                            case 23: {
                                zzIsFinal = true;
                                this.zzState = 27;
                                break block0;
                            }
                            case 5: {
                                zzIsFinal = true;
                                this.zzState = 28;
                                break block0;
                            }
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                this.zzState = 29;
                                break block0;
                            }
                            case 24: 
                            case 25: {
                                zzIsFinal = true;
                                this.zzState = 30;
                                break block0;
                            }
                            case 26: 
                            case 27: {
                                zzIsFinal = true;
                                this.zzState = 31;
                                break block0;
                            }
                            case 30: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 32;
                                break block0;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 12;
                        break;
                    }
                    case 5: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 33;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 6: {
                        switch (zzInput) {
                            case 0: 
                            case 4: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 5;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 33;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 8: {
                        switch (zzInput) {
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 34;
                                break;
                            }
                            case 6: 
                            case 7: 
                            case 9: {
                                break block793;
                            }
                            default: {
                                zzIsFinal = true;
                                this.zzState = 5;
                                break;
                            }
                        }
                        break;
                    }
                    case 9: {
                        switch (zzInput) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 13: {
                        switch (zzInput) {
                            case 0: 
                            case 4: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 35;
                                break block0;
                            }
                            case 1: {
                                this.zzState = 36;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 37;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 15: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 38;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 39;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 16: {
                        switch (zzInput) {
                            case 0: 
                            case 4: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 40;
                                break block0;
                            }
                            case 1: {
                                this.zzState = 41;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 42;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 17: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 43;
                                break block0;
                            }
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                this.zzState = 44;
                                break block0;
                            }
                            case 13: 
                            case 19: 
                            case 20: {
                                this.zzState = 45;
                                break block0;
                            }
                            case 18: {
                                this.zzState = 46;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 18: {
                        switch (zzInput) {
                            case 0: 
                            case 4: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 43;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 19: {
                        switch (zzInput) {
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 47;
                                break;
                            }
                            case 6: 
                            case 7: 
                            case 9: {
                                break block793;
                            }
                            default: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break;
                            }
                        }
                        break;
                    }
                    case 20: {
                        switch (zzInput) {
                            case 0: 
                            case 4: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 43;
                                break block0;
                            }
                            case 1: {
                                this.zzState = 48;
                                break block0;
                            }
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                this.zzState = 49;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 23: {
                        switch (zzInput) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                break block0;
                            }
                            case 19: {
                                zzIsFinal = true;
                                this.zzState = 24;
                                break block0;
                            }
                            case 22: {
                                zzIsFinal = true;
                                this.zzState = 25;
                                break block0;
                            }
                            case 23: {
                                zzIsFinal = true;
                                this.zzState = 26;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 24: {
                        switch (zzInput) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 25: {
                        switch (zzInput) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 26: {
                        switch (zzInput) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 27: {
                        switch (zzInput) {
                            case 5: {
                                this.zzState = 50;
                                break block0;
                            }
                            case 24: 
                            case 25: {
                                this.zzState = 51;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 28: {
                        switch (zzInput) {
                            case 5: {
                                this.zzState = 50;
                                break block0;
                            }
                            case 24: 
                            case 25: {
                                this.zzState = 51;
                                break block0;
                            }
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                this.zzState = 52;
                                break block0;
                            }
                            case 34: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 53;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 29: {
                        switch (zzInput) {
                            case 5: {
                                this.zzState = 50;
                                break block0;
                            }
                            case 24: 
                            case 25: {
                                this.zzState = 51;
                                break block0;
                            }
                            case 1: 
                            case 23: {
                                this.zzState = 54;
                                break block0;
                            }
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                this.zzState = 55;
                                break block0;
                            }
                            case 26: 
                            case 27: {
                                this.zzState = 56;
                                break block0;
                            }
                            case 30: 
                            case 31: {
                                this.zzState = 57;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 30: {
                        switch (zzInput) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                this.zzState = 51;
                                break block0;
                            }
                            case 34: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 53;
                                break block0;
                            }
                            case 1: 
                            case 23: {
                                this.zzState = 58;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 31: {
                        switch (zzInput) {
                            case 28: 
                            case 29: {
                                this.zzState = 59;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 32: {
                        switch (zzInput) {
                            case 32: 
                            case 33: {
                                this.zzState = 60;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 33: {
                        switch (zzInput) {
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 34;
                                break;
                            }
                            case 6: 
                            case 7: 
                            case 9: {
                                break block793;
                            }
                            default: {
                                zzIsFinal = true;
                                this.zzState = 5;
                                break;
                            }
                        }
                        break;
                    }
                    case 34: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 5;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 33;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 61;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 62;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 35: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 37;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 36: {
                        switch (zzInput) {
                            case 0: 
                            case 4: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 35;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 37;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 37: {
                        switch (zzInput) {
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 63;
                                break;
                            }
                            case 6: 
                            case 7: 
                            case 9: {
                                break block793;
                            }
                            default: {
                                zzIsFinal = true;
                                this.zzState = 35;
                                break;
                            }
                        }
                        break;
                    }
                    case 38: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 39;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 39: {
                        switch (zzInput) {
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 64;
                                break;
                            }
                            case 6: 
                            case 7: 
                            case 9: {
                                break block793;
                            }
                            default: {
                                zzIsFinal = true;
                                this.zzState = 38;
                                break;
                            }
                        }
                        break;
                    }
                    case 40: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 42;
                                break block0;
                            }
                            case 17: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 65;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 41: {
                        switch (zzInput) {
                            case 0: 
                            case 4: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 40;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 42;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 42: {
                        switch (zzInput) {
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 66;
                                break;
                            }
                            case 6: 
                            case 7: 
                            case 9: {
                                break block793;
                            }
                            default: {
                                zzIsFinal = true;
                                this.zzState = 40;
                                break;
                            }
                        }
                        break;
                    }
                    case 43: {
                        switch (zzInput) {
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 47;
                                break;
                            }
                            case 6: 
                            case 7: 
                            case 9: {
                                break block793;
                            }
                            default: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break;
                            }
                        }
                        break;
                    }
                    case 44: {
                        switch (zzInput) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                break block0;
                            }
                            case 13: 
                            case 19: 
                            case 20: {
                                this.zzState = 45;
                                break block0;
                            }
                            case 18: {
                                this.zzState = 46;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 45: {
                        switch (zzInput) {
                            case 18: {
                                this.zzState = 46;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 46: {
                        switch (zzInput) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                break block0;
                            }
                            case 0: 
                            case 4: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 67;
                                break block0;
                            }
                            case 1: {
                                this.zzState = 68;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 69;
                                break block0;
                            }
                            case 11: {
                                this.zzState = 70;
                                break block0;
                            }
                            case 12: {
                                this.zzState = 71;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 47: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 43;
                                break block0;
                            }
                            case 13: 
                            case 19: 
                            case 20: {
                                this.zzState = 45;
                                break block0;
                            }
                            case 18: {
                                this.zzState = 46;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 72;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 73;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 48: {
                        switch (zzInput) {
                            case 0: 
                            case 4: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 43;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 49: {
                        switch (zzInput) {
                            case 0: 
                            case 4: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 43;
                                break block0;
                            }
                            case 1: {
                                this.zzState = 48;
                                break block0;
                            }
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 50: {
                        switch (zzInput) {
                            case 5: {
                                break block0;
                            }
                            case 24: 
                            case 25: {
                                this.zzState = 51;
                                break block0;
                            }
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                this.zzState = 52;
                                break block0;
                            }
                            case 34: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 53;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 51: {
                        switch (zzInput) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                break block0;
                            }
                            case 34: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 53;
                                break block0;
                            }
                            case 1: 
                            case 23: {
                                this.zzState = 58;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 52: {
                        switch (zzInput) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                break block0;
                            }
                            case 34: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 53;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 54: {
                        switch (zzInput) {
                            case 5: {
                                this.zzState = 50;
                                break block0;
                            }
                            case 24: 
                            case 25: {
                                this.zzState = 51;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 55: {
                        switch (zzInput) {
                            case 5: {
                                this.zzState = 50;
                                break block0;
                            }
                            case 24: 
                            case 25: {
                                this.zzState = 51;
                                break block0;
                            }
                            case 1: 
                            case 23: {
                                this.zzState = 54;
                                break block0;
                            }
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                break block0;
                            }
                            case 26: 
                            case 27: {
                                this.zzState = 56;
                                break block0;
                            }
                            case 30: 
                            case 31: {
                                this.zzState = 57;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 56: {
                        switch (zzInput) {
                            case 28: 
                            case 29: {
                                this.zzState = 59;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 57: {
                        switch (zzInput) {
                            case 32: 
                            case 33: {
                                this.zzState = 60;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 58: {
                        switch (zzInput) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                break block0;
                            }
                            case 5: {
                                this.zzState = 74;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 59: {
                        switch (zzInput) {
                            case 28: 
                            case 29: {
                                this.zzState = 52;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 60: {
                        switch (zzInput) {
                            case 30: 
                            case 31: {
                                this.zzState = 75;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 61: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 5;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 33;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 62;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 76;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 62: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 5;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 33;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 63: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 35;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 37;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 77;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 78;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 64: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 38;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 39;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 79;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 80;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 66: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 40;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 42;
                                break block0;
                            }
                            case 17: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 65;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 81;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 82;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 67: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 69;
                                break block0;
                            }
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 68: {
                        switch (zzInput) {
                            case 0: 
                            case 4: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 67;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 69;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 69: {
                        switch (zzInput) {
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 84;
                                break;
                            }
                            case 6: 
                            case 7: 
                            case 9: {
                                break block793;
                            }
                            default: {
                                zzIsFinal = true;
                                this.zzState = 67;
                                break;
                            }
                        }
                        break;
                    }
                    case 70: {
                        switch (zzInput) {
                            case 11: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break;
                            }
                            case 3: {
                                this.zzState = 85;
                                break;
                            }
                            case 6: 
                            case 7: 
                            case 9: {
                                break block793;
                            }
                        }
                        break;
                    }
                    case 71: {
                        switch (zzInput) {
                            case 12: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break;
                            }
                            case 3: {
                                this.zzState = 86;
                                break;
                            }
                            case 6: 
                            case 7: 
                            case 9: {
                                break block793;
                            }
                        }
                        break;
                    }
                    case 72: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 43;
                                break block0;
                            }
                            case 13: 
                            case 19: 
                            case 20: {
                                this.zzState = 45;
                                break block0;
                            }
                            case 18: {
                                this.zzState = 46;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 73;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 87;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 73: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 43;
                                break block0;
                            }
                            case 6: 
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                this.zzState = 44;
                                break block0;
                            }
                            case 13: 
                            case 19: 
                            case 20: {
                                this.zzState = 45;
                                break block0;
                            }
                            case 18: {
                                this.zzState = 46;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 74: {
                        switch (zzInput) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                this.zzState = 52;
                                break block0;
                            }
                            case 34: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 53;
                                break block0;
                            }
                            case 5: {
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 75: {
                        switch (zzInput) {
                            case 24: 
                            case 25: {
                                this.zzState = 52;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 76: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 5;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 33;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 62;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 88;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 77: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 35;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 37;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 78;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 89;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 78: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 35;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 37;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 79: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 38;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 39;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 80;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 90;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 80: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 38;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 39;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 81: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 40;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 42;
                                break block0;
                            }
                            case 17: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 65;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 82;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 91;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 82: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 40;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 42;
                                break block0;
                            }
                            case 17: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 65;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 83: {
                        switch (zzInput) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 84: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 67;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 69;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 92;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 93;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 85: {
                        switch (zzInput) {
                            case 3: {
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                this.zzState = 94;
                                break block0;
                            }
                            case 6: {
                                this.zzState = 95;
                                break block0;
                            }
                            case 11: {
                                zzIsFinal = true;
                                this.zzState = 96;
                                break block0;
                            }
                        }
                        this.zzState = 70;
                        break;
                    }
                    case 86: {
                        switch (zzInput) {
                            case 3: {
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                this.zzState = 97;
                                break block0;
                            }
                            case 6: {
                                this.zzState = 98;
                                break block0;
                            }
                            case 12: {
                                zzIsFinal = true;
                                this.zzState = 99;
                                break block0;
                            }
                        }
                        this.zzState = 71;
                        break;
                    }
                    case 87: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 43;
                                break block0;
                            }
                            case 13: 
                            case 19: 
                            case 20: {
                                this.zzState = 45;
                                break block0;
                            }
                            case 18: {
                                this.zzState = 46;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 73;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 100;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 88: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 5;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 33;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 62;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 101;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 89: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 35;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 37;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 78;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 102;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 90: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 38;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 39;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 80;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 103;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 91: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 40;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 42;
                                break block0;
                            }
                            case 17: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 65;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 82;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 104;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 92: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 67;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 69;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 93;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 105;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 93: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 67;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 69;
                                break block0;
                            }
                            case 6: 
                            case 8: 
                            case 9: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 94: {
                        switch (zzInput) {
                            case 11: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 85;
                                break block0;
                            }
                            case 6: {
                                this.zzState = 95;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                this.zzState = 106;
                                break block0;
                            }
                        }
                        this.zzState = 70;
                        break;
                    }
                    case 95: {
                        switch (zzInput) {
                            case 11: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break;
                            }
                            case 3: {
                                this.zzState = 85;
                                break;
                            }
                            case 6: 
                            case 9: {
                                break block793;
                            }
                            default: {
                                this.zzState = 70;
                                break;
                            }
                        }
                        break;
                    }
                    case 96: {
                        switch (zzInput) {
                            case 6: 
                            case 7: 
                            case 9: 
                            case 11: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 85;
                                break block0;
                            }
                            case 8: {
                                zzIsFinal = true;
                                break block0;
                            }
                        }
                        this.zzState = 70;
                        break;
                    }
                    case 97: {
                        switch (zzInput) {
                            case 12: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 86;
                                break block0;
                            }
                            case 6: {
                                this.zzState = 98;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                this.zzState = 107;
                                break block0;
                            }
                        }
                        this.zzState = 71;
                        break;
                    }
                    case 98: {
                        switch (zzInput) {
                            case 12: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break;
                            }
                            case 3: {
                                this.zzState = 86;
                                break;
                            }
                            case 6: 
                            case 9: {
                                break block793;
                            }
                            default: {
                                this.zzState = 71;
                                break;
                            }
                        }
                        break;
                    }
                    case 99: {
                        switch (zzInput) {
                            case 6: 
                            case 7: 
                            case 9: 
                            case 12: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 86;
                                break block0;
                            }
                            case 8: {
                                zzIsFinal = true;
                                break block0;
                            }
                        }
                        this.zzState = 71;
                        break;
                    }
                    case 100: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 43;
                                break block0;
                            }
                            case 13: 
                            case 19: 
                            case 20: {
                                this.zzState = 45;
                                break block0;
                            }
                            case 18: {
                                this.zzState = 46;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 73;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 108;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 101: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 5;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 33;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 62;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 109;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 102: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 35;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 37;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 78;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 110;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 103: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 38;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 39;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 80;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 111;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 104: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 40;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 42;
                                break block0;
                            }
                            case 17: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 65;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 82;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 112;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 105: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 67;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 69;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 93;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 113;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 106: {
                        switch (zzInput) {
                            case 11: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 85;
                                break block0;
                            }
                            case 6: {
                                this.zzState = 95;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                this.zzState = 114;
                                break block0;
                            }
                        }
                        this.zzState = 70;
                        break;
                    }
                    case 107: {
                        switch (zzInput) {
                            case 12: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 86;
                                break block0;
                            }
                            case 6: {
                                this.zzState = 98;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                this.zzState = 115;
                                break block0;
                            }
                        }
                        this.zzState = 71;
                        break;
                    }
                    case 108: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 43;
                                break block0;
                            }
                            case 13: 
                            case 19: 
                            case 20: {
                                this.zzState = 45;
                                break block0;
                            }
                            case 18: {
                                this.zzState = 46;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 73;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 116;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 109: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 5;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 33;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 62;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 110: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 35;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 37;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 78;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 117;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 111: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 38;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 39;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 80;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 118;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 112: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 40;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 42;
                                break block0;
                            }
                            case 17: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 65;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 82;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 119;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 113: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 67;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 69;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 93;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 120;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 114: {
                        switch (zzInput) {
                            case 11: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 85;
                                break block0;
                            }
                            case 6: {
                                this.zzState = 95;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                this.zzState = 121;
                                break block0;
                            }
                        }
                        this.zzState = 70;
                        break;
                    }
                    case 115: {
                        switch (zzInput) {
                            case 12: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 86;
                                break block0;
                            }
                            case 6: {
                                this.zzState = 98;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                this.zzState = 122;
                                break block0;
                            }
                        }
                        this.zzState = 71;
                        break;
                    }
                    case 116: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 43;
                                break block0;
                            }
                            case 13: 
                            case 19: 
                            case 20: {
                                this.zzState = 45;
                                break block0;
                            }
                            case 18: {
                                this.zzState = 46;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 73;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 117: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 35;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 37;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 78;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 118: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 38;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 39;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 80;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 119: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 40;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 42;
                                break block0;
                            }
                            case 17: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 65;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 82;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 120: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 67;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 69;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 93;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                zzIsFinal = true;
                                this.zzState = 123;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 121: {
                        switch (zzInput) {
                            case 11: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 85;
                                break block0;
                            }
                            case 6: {
                                this.zzState = 95;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                this.zzState = 124;
                                break block0;
                            }
                        }
                        this.zzState = 70;
                        break;
                    }
                    case 122: {
                        switch (zzInput) {
                            case 12: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 86;
                                break block0;
                            }
                            case 6: {
                                this.zzState = 98;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                this.zzState = 125;
                                break block0;
                            }
                        }
                        this.zzState = 71;
                        break;
                    }
                    case 123: {
                        switch (zzInput) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 24: 
                            case 26: 
                            case 29: 
                            case 31: 
                            case 32: {
                                zzIsFinal = true;
                                this.zzState = 67;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 69;
                                break block0;
                            }
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 93;
                                break block0;
                            }
                        }
                        break block793;
                    }
                    case 124: {
                        switch (zzInput) {
                            case 11: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 85;
                                break block0;
                            }
                            case 6: {
                                this.zzState = 95;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                this.zzState = 126;
                                break block0;
                            }
                        }
                        this.zzState = 70;
                        break;
                    }
                    case 125: {
                        switch (zzInput) {
                            case 12: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 86;
                                break block0;
                            }
                            case 6: {
                                this.zzState = 98;
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 29: 
                            case 31: {
                                this.zzState = 127;
                                break block0;
                            }
                        }
                        this.zzState = 71;
                        break;
                    }
                    case 126: {
                        switch (zzInput) {
                            case 11: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 85;
                                break block0;
                            }
                            case 6: {
                                this.zzState = 95;
                                break block0;
                            }
                        }
                        this.zzState = 70;
                        break;
                    }
                    case 127: {
                        switch (zzInput) {
                            case 12: {
                                zzIsFinal = true;
                                this.zzState = 83;
                                break block0;
                            }
                            case 3: {
                                this.zzState = 86;
                                break block0;
                            }
                            case 6: {
                                this.zzState = 98;
                                break block0;
                            }
                        }
                        this.zzState = 71;
                        break;
                    }
                    default: {
                        this.zzScanError(0);
                    }
                }
                if (!zzIsFinal) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if (zzNoLookAhead) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 9: {
                    this.cssSelector.addAttributeSelector(this.yytext());
                }
                case 20: {
                    continue block792;
                }
                case 14: {
                    this.cssSelector.setCombinator(Combinator.ADJACENT_SIBLING);
                    this.stateReset();
                }
                case 21: {
                    continue block792;
                }
                case 6: {
                    this.cssSelector = new CssSelector();
                    this.selectors.add(this.cssSelector);
                    this.stateSelector();
                }
                case 22: {
                    continue block792;
                }
                case 1: 
                case 23: {
                    continue block792;
                }
                case 19: {
                    this.pseudoFnName = this.yytext(1, 1);
                    this.statePseudoFn();
                }
                case 24: {
                    continue block792;
                }
                case 12: {
                    this.cssSelector.setCombinator(Combinator.GENERAL_SIBLING);
                    this.stateReset();
                }
                case 25: {
                    continue block792;
                }
                case 10: {
                    this.stateSelector();
                }
                case 26: {
                    continue block792;
                }
                case 18: {
                    this.cssSelector.addPseudoFunctionSelector(this.pseudoFnName, this.yytext(0, 1));
                    this.stateSelector();
                }
                case 27: {
                    continue block792;
                }
                case 8: {
                    this.stateAttr();
                }
                case 28: {
                    continue block792;
                }
                case 17: {
                    this.cssSelector.addPseudoClassSelector(this.yytext(1));
                }
                case 29: {
                    continue block792;
                }
                case 7: {
                    throw new CSSellyException("Illegal character <" + this.yytext() + ">.", this.yystate(), this.line(), this.column());
                }
                case 30: {
                    continue block792;
                }
                case 2: {
                    this.yypushback(1);
                    this.stateCombinator();
                }
                case 31: {
                    continue block792;
                }
                case 4: {
                    this.cssSelector = new CssSelector(this.yytext());
                    this.selectors.add(this.cssSelector);
                    this.stateSelector();
                }
                case 32: {
                    continue block792;
                }
                case 5: {
                    this.cssSelector = new CssSelector();
                    this.selectors.add(this.cssSelector);
                    this.yypushback(1);
                    this.stateSelector();
                }
                case 33: {
                    continue block792;
                }
                case 3: {
                    this.cssSelector.setCombinator(Combinator.DESCENDANT);
                    this.stateReset();
                }
                case 34: {
                    continue block792;
                }
                case 16: {
                    this.cssSelector.addIdSelector(this.yytext(1));
                }
                case 35: {
                    continue block792;
                }
                case 15: {
                    this.cssSelector.addClassSelector(this.yytext(1));
                }
                case 36: {
                    continue block792;
                }
                case 11: {
                    throw new CSSellyException("Invalid combinator <" + this.yytext() + ">.", this.yystate(), this.line(), this.column());
                }
                case 37: {
                    continue block792;
                }
                case 13: {
                    this.cssSelector.setCombinator(Combinator.CHILD);
                    this.stateReset();
                }
                case 38: {
                    continue block792;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                return 0;
            }
            this.zzScanError(1);
        }
    }
}

