/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.adapter.htmlstapler;

import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jodd.lagarto.adapter.htmlstapler.HtmlStaplerBundlesManager;
import jodd.servlet.DispatcherUtil;
import jodd.servlet.ServletUtil;
import jodd.util.ArraysUtil;

public class BundleAction {
    private static final String BUNDLE_ID_MARKER = "---jodd-bundle-id-marker---";
    private static final String UNSTAPLE_MARKER = "jodd-unstaple";
    protected final HtmlStaplerBundlesManager bundlesManager;
    protected final String bundleName;
    protected final boolean newAction;
    protected final String actionPath;
    protected final String contextPath;
    protected final HtmlStaplerBundlesManager.Strategy strategy;
    protected String bundleId;
    protected char[] bundleIdMark;
    protected List<String> sources;
    protected boolean firstScriptTag;

    public BundleAction(HtmlStaplerBundlesManager bundlesManager, HttpServletRequest request, String bundleName) {
        this.bundlesManager = bundlesManager;
        this.bundleName = bundleName;
        this.strategy = bundlesManager.getStrategy();
        String realActionPath = bundlesManager.resolveRealActionPath(DispatcherUtil.getServletPath((HttpServletRequest)request));
        this.actionPath = realActionPath + '*' + bundleName;
        this.contextPath = ServletUtil.getContextPath((HttpServletRequest)request);
        if (this.strategy == HtmlStaplerBundlesManager.Strategy.ACTION_MANAGED) {
            this.bundleId = bundlesManager.lookupBundleId(this.actionPath);
            boolean bl = this.newAction = this.bundleId == null;
            if (this.newAction) {
                this.sources = new LinkedList<String>();
            }
        } else {
            this.bundleId = BUNDLE_ID_MARKER + bundleName;
            this.bundleIdMark = this.bundleId.toCharArray();
            this.newAction = true;
            this.sources = new LinkedList<String>();
        }
        this.firstScriptTag = true;
    }

    public boolean acceptLink(String src) {
        if (src == null) {
            return false;
        }
        return !src.contains(UNSTAPLE_MARKER);
    }

    public String processLink(String src) {
        if (this.newAction) {
            if (this.bundleId == null) {
                this.bundleId = this.bundlesManager.registerNewBundleId();
            }
            this.sources.add(src);
        }
        if (this.firstScriptTag) {
            this.firstScriptTag = false;
            return this.contextPath + this.bundlesManager.getStaplerServletPath() + "?id=" + this.bundleId;
        }
        return null;
    }

    public void end() {
        if (this.newAction) {
            this.bundleId = this.bundlesManager.registerBundle(this.actionPath, this.bundleId, this.sources);
        }
    }

    public char[] replaceBundleId(char[] content) {
        if (this.strategy == HtmlStaplerBundlesManager.Strategy.ACTION_MANAGED || this.bundleId == null) {
            return content;
        }
        int index = ArraysUtil.indexOf((char[])content, (char[])this.bundleIdMark);
        if (index == -1) {
            return content;
        }
        char[] bundleIdChars = this.bundleId.toCharArray();
        char[] result = new char[content.length - this.bundleIdMark.length + bundleIdChars.length];
        System.arraycopy(content, 0, result, 0, index);
        System.arraycopy(bundleIdChars, 0, result, index, bundleIdChars.length);
        System.arraycopy(content, index + this.bundleIdMark.length, result, index + bundleIdChars.length, content.length - this.bundleIdMark.length - index);
        return result;
    }
}

