/*
 * Decompiled with CFR 0.152.
 */
package jodd.decora;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.CharBuffer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.decora.BufferResponseWrapper;
import jodd.decora.DecoraManager;
import jodd.decora.DecoraRequestWrapper;
import jodd.decora.DecoraResponseWrapper;
import jodd.decora.LastModifiedData;
import jodd.decora.parser.DecoraParser;
import jodd.log.Log;
import jodd.servlet.DispatcherUtil;
import jodd.util.ClassLoaderUtil;

public class DecoraServletFilter
implements Filter {
    private static final Log log = Log.getLogger(DecoraServletFilter.class);
    public static final String PARAM_DECORA_MANAGER = "decora.manager";
    public static final String PARAM_DECORA_PARSER = "decora.parser";
    protected DecoraManager decoraManager;
    protected DecoraParser decoraParser;

    protected DecoraManager createDecoraManager() {
        return new DecoraManager();
    }

    protected DecoraParser createDecoraParser() {
        return new DecoraParser();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String decoraManagerClass = filterConfig.getInitParameter(PARAM_DECORA_MANAGER);
        if (decoraManagerClass != null) {
            try {
                Class decoraManagerType = ClassLoaderUtil.loadClass((String)decoraManagerClass);
                this.decoraManager = (DecoraManager)decoraManagerType.newInstance();
            }
            catch (Exception ex) {
                log.error("Unable to load Decora manager class: " + decoraManagerClass, ex);
                throw new ServletException((Throwable)ex);
            }
        } else {
            this.decoraManager = this.createDecoraManager();
        }
        String decoraParserClass = filterConfig.getInitParameter(PARAM_DECORA_PARSER);
        if (decoraParserClass != null) {
            try {
                Class decoraParserType = ClassLoaderUtil.loadClass((String)decoraParserClass);
                this.decoraParser = (DecoraParser)decoraParserType.newInstance();
            }
            catch (Exception ex) {
                log.error("Unable to load Decora parser class: " + decoraParserClass, ex);
                throw new ServletException((Throwable)ex);
            }
        } else {
            this.decoraParser = this.createDecoraParser();
        }
    }

    public void destroy() {
    }

    protected HttpServletRequest wrapRequest(HttpServletRequest request) {
        return new DecoraRequestWrapper(request);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String actionPath;
        String decoratorPath;
        final HttpServletRequest request = (HttpServletRequest)servletRequest;
        final HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.decoraManager.decorateRequest(request)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest decoraRequest = this.wrapRequest(request);
        LastModifiedData lastModifiedData = new LastModifiedData();
        DecoraResponseWrapper pageWrapper = new DecoraResponseWrapper(response, lastModifiedData, this.decoraManager){

            protected void preResponseCommit() {
                long lastModified = this.lastModifiedData.getLastModified();
                long ifModifiedSince = request.getDateHeader("If-Modified-Since");
                if (lastModified > -1L && !response.containsHeader("Last-Modified")) {
                    if (ifModifiedSince < lastModified / 1000L * 1000L) {
                        response.setDateHeader("Last-Modified", lastModified);
                    } else {
                        response.reset();
                        response.setStatus(304);
                    }
                }
            }
        };
        filterChain.doFilter((ServletRequest)decoraRequest, (ServletResponse)pageWrapper);
        char[] pageContent = pageWrapper.getBufferedChars();
        boolean decorated = false;
        if (pageContent != null && pageWrapper.isBufferingEnabled() && (decoratorPath = this.decoraManager.resolveDecorator(request, actionPath = DispatcherUtil.getServletPath((HttpServletRequest)request))) != null) {
            BufferResponseWrapper decoratorWrapper = new BufferResponseWrapper(response, lastModifiedData);
            DispatcherUtil.forward((ServletRequest)decoraRequest, (ServletResponse)decoratorWrapper, (String)decoratorPath);
            char[] decoraContent = decoratorWrapper.getBufferedChars();
            this.decoraParser.decorate(servletResponse.getWriter(), pageContent, decoraContent);
            decorated = true;
        }
        if (!response.isCommitted()) {
            pageWrapper.preResponseCommit();
        }
        if (pageContent != null && !decorated) {
            if (pageWrapper.isBufferStreamBased()) {
                ServletOutputStream outputStream = response.getOutputStream();
                outputStream.write(pageWrapper.getBufferedBytes());
                outputStream.flush();
            } else {
                PrintWriter writer = response.getWriter();
                writer.append(CharBuffer.wrap(pageContent));
                writer.flush();
            }
        }
    }
}

