/*
 * Decompiled with CFR 0.152.
 */
package jodd.swingspy;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class SwingUtil {
    public static void enableJDK5AntiAliasedText() {
        System.setProperty("swing.aatext", "true");
    }

    public static void scrollToTop(JScrollPane scrollPane) {
        JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
        JScrollBar horizontalScrollBar = scrollPane.getHorizontalScrollBar();
        verticalScrollBar.setValue(verticalScrollBar.getMinimum());
        horizontalScrollBar.setValue(horizontalScrollBar.getMinimum());
    }

    public static void scrollToTopLater(final JScrollPane scrollPane) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingUtil.scrollToTop(scrollPane);
            }
        });
    }

    public static void center(JFrame frame) {
        Dimension frameSize = frame.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width - frameSize.width >> 1, screenSize.height - frameSize.height >> 1);
    }

    public static void center(JDialog dialog) {
        Dimension dialogSize = dialog.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setLocation(screenSize.width - dialogSize.width >> 1, screenSize.height - dialogSize.height >> 1);
    }

    public static void enforceJEditorPaneFont(JEditorPane jEditorPane, Font font) {
        jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jEditorPane.setFont(font);
    }
}

