/*
 * Decompiled with CFR 0.152.
 */
package jodd.swingspy;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import jodd.bean.BeanTool;
import jodd.servlet.HtmlEncoder;
import jodd.swingspy.SwingUtil;

public class SwingSpyPanel
extends JPanel {
    private JTree componentTree;
    private JEditorPane componentData;
    private JEditorPane detailsData;
    private JScrollPane detailsScrollPane;
    private DefaultMutableTreeNode root;
    private static final int INITIAL_WIDTH = 600;
    private static final int INITIAL_HEIGHT = 500;
    private Font font = new Font("Arial", 0, 12);

    public SwingSpyPanel() {
        this.setPreferredSize(new Dimension(600, 500));
        this.setLayout(new BorderLayout());
        this.root = new DefaultMutableTreeNode();
        this.componentTree = new JTree(this.root);
        this.componentTree.setRootVisible(false);
        this.componentTree.setCellRenderer(new SwingComponentRenderer());
        this.componentTree.addTreeSelectionListener(new CustomSelectionListener());
        this.detailsData = new JEditorPane();
        this.detailsData.setBackground(new Color(250, 250, 250));
        this.detailsData.setForeground(new Color(33, 33, 33));
        this.detailsData.setBorder(BorderFactory.createLineBorder(new Color(100, 100, 244), 1));
        this.detailsData.setPreferredSize(new Dimension(150, 500));
        this.detailsData.setEditable(false);
        this.detailsData.setContentType("text/html");
        SwingUtil.enforceJEditorPaneFont(this.detailsData, this.font);
        this.detailsScrollPane = new JScrollPane(this.detailsData);
        JSplitPane hPane = new JSplitPane(1, new JScrollPane(this.componentTree), this.detailsScrollPane);
        hPane.setContinuousLayout(true);
        hPane.setOneTouchExpandable(true);
        hPane.setDividerLocation(400);
        this.add((Component)hPane, "Center");
        this.componentData = new JEditorPane();
        this.componentData.setBackground(new Color(250, 250, 250));
        this.componentData.setForeground(new Color(33, 33, 33));
        this.componentData.setBorder(BorderFactory.createLineBorder(new Color(100, 100, 244), 1));
        this.componentData.setPreferredSize(new Dimension(600, 36));
        this.componentData.setEditable(false);
        this.componentData.setContentType("text/html");
        SwingUtil.enforceJEditorPaneFont(this.componentData, this.font);
        this.add((Component)this.componentData, "South");
    }

    public void reload(Component rootComponent, Component selectedComponent) {
        this.root.removeAllChildren();
        this.addNode(this.root, rootComponent, selectedComponent);
        SwingUtilities.updateComponentTreeUI(this.componentTree);
    }

    protected void addNode(DefaultMutableTreeNode parent, Component component, Component selectedComponent) {
        DefaultMutableTreeNode componentNode = new DefaultMutableTreeNode(new ComponentWrapper(component));
        parent.add(componentNode);
        if (component == selectedComponent) {
            TreePath selectedPath = new TreePath(componentNode.getPath());
            this.componentTree.setSelectionPath(selectedPath);
            this.componentTree.scrollPathToVisible(selectedPath);
        }
        if (component instanceof Container) {
            Component[] childComponents;
            Container container = (Container)component;
            for (Component child : childComponents = container.getComponents()) {
                this.addNode(componentNode, child, selectedComponent);
            }
        }
    }

    static class SwingComponentRenderer
    extends DefaultTreeCellRenderer {
        private static ImageIcon noneIcon;
        private static Class[] cmpClasses;
        private static ImageIcon[] cmpIcons;

        SwingComponentRenderer() {
        }

        protected static ImageIcon createImageIcon(String path) {
            URL imgURL = SwingComponentRenderer.class.getResource(path);
            if (imgURL != null) {
                return new ImageIcon(imgURL);
            }
            System.err.println("Couldn't find icon file: " + path);
            return null;
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() != null) {
                ComponentWrapper userObject = (ComponentWrapper)node.getUserObject();
                if (userObject != null) {
                    Component c = userObject.component;
                    for (int i = 0; i < cmpClasses.length; ++i) {
                        Class clazz = cmpClasses[i];
                        if (!clazz.isAssignableFrom(c.getClass())) continue;
                        this.setIcon(cmpIcons[i]);
                        return this;
                    }
                }
                this.setIcon(noneIcon);
            }
            return this;
        }

        static {
            String packageName = SwingComponentRenderer.class.getPackage().getName();
            packageName = '/' + packageName.replace('.', '/') + "/icons/";
            noneIcon = SwingComponentRenderer.createImageIcon(packageName + "none.png");
            cmpClasses = new Class[]{JButton.class, JCheckBox.class, JComboBox.class, JLabel.class, JList.class, JPanel.class, JProgressBar.class, JRadioButton.class, JScrollBar.class, JScrollPane.class, JSlider.class, JTabbedPane.class, JTextArea.class, JTextField.class, JTree.class, JEditorPane.class, JFormattedTextField.class, JPasswordField.class, JSpinner.class, JTable.class, JTextPane.class, JToolBar.class, JLayeredPane.class, JSplitPane.class, JSeparator.class};
            cmpIcons = new ImageIcon[]{SwingComponentRenderer.createImageIcon(packageName + "button.png"), SwingComponentRenderer.createImageIcon(packageName + "checkBox.png"), SwingComponentRenderer.createImageIcon(packageName + "comboBox.png"), SwingComponentRenderer.createImageIcon(packageName + "label.png"), SwingComponentRenderer.createImageIcon(packageName + "list.png"), SwingComponentRenderer.createImageIcon(packageName + "panel.png"), SwingComponentRenderer.createImageIcon(packageName + "progressBar.png"), SwingComponentRenderer.createImageIcon(packageName + "radioButton.png"), SwingComponentRenderer.createImageIcon(packageName + "scrollbar.png"), SwingComponentRenderer.createImageIcon(packageName + "scrollPane.png"), SwingComponentRenderer.createImageIcon(packageName + "slider.png"), SwingComponentRenderer.createImageIcon(packageName + "tabbedPane.png"), SwingComponentRenderer.createImageIcon(packageName + "textArea.png"), SwingComponentRenderer.createImageIcon(packageName + "textField.png"), SwingComponentRenderer.createImageIcon(packageName + "tree.png"), SwingComponentRenderer.createImageIcon(packageName + "editorPane.png"), SwingComponentRenderer.createImageIcon(packageName + "formattedTextField.png"), SwingComponentRenderer.createImageIcon(packageName + "passwordField.png"), SwingComponentRenderer.createImageIcon(packageName + "spinner.png"), SwingComponentRenderer.createImageIcon(packageName + "table.png"), SwingComponentRenderer.createImageIcon(packageName + "textPane.png"), SwingComponentRenderer.createImageIcon(packageName + "toolbar.png"), SwingComponentRenderer.createImageIcon(packageName + "panel.png"), SwingComponentRenderer.createImageIcon(packageName + "splitPane.png"), SwingComponentRenderer.createImageIcon(packageName + "separator.png")};
        }
    }

    class CustomSelectionListener
    implements TreeSelectionListener {
        CustomSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent tse) {
            DefaultMutableTreeNode lastNode = (DefaultMutableTreeNode)tse.getPath().getLastPathComponent();
            ComponentWrapper cmp = (ComponentWrapper)lastNode.getUserObject();
            SwingSpyPanel.this.componentData.setText(cmp.toHtmlString());
            SwingSpyPanel.this.detailsData.setText(cmp.toDetailedString());
            SwingUtil.scrollToTopLater(SwingSpyPanel.this.detailsScrollPane);
        }
    }

    static class ComponentWrapper {
        Component component;

        ComponentWrapper(Component component) {
            this.component = component;
        }

        public String toString() {
            String name = this.component.getName();
            return (name != null ? name + "  " : "") + '(' + this.component.getClass().getSimpleName() + ')';
        }

        public String toHtmlString() {
            StringBuilder str = new StringBuilder("<html>");
            str.append("&nbsp;name: ").append("<b>").append(this.component.getName()).append("</b><br>");
            str.append("&nbsp;class: ").append("<b>").append(this.component.getClass().getName()).append("</b><br>");
            return str.toString();
        }

        public String toDetailedString() {
            StringBuilder str = new StringBuilder("<html>");
            str.append(HtmlEncoder.block((String)BeanTool.attributesToString((Object)this.component)));
            return str.toString();
        }
    }
}

