/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.methref;

import jodd.proxetta.MethodInfo;
import jodd.proxetta.ProxyAspect;
import jodd.proxetta.impl.ProxyProxetta;
import jodd.proxetta.impl.ProxyProxettaBuilder;
import jodd.proxetta.methref.MethrefAdvice;
import jodd.proxetta.methref.MethrefStringAdvice;
import jodd.proxetta.pointcuts.AllMethodsPointcut;

public class MethrefProxetta {
    protected final ProxyProxetta proxetta;
    public static final String METHREF_CLASSNAME_SUFFIX = "$Methref";

    public MethrefProxetta() {
        ProxyAspect aspectAll = new ProxyAspect(MethrefAdvice.class, new AllMethodsPointcut(){

            public boolean apply(MethodInfo methodInfo) {
                if (methodInfo.getReturnType().equals(String.class.getName())) {
                    return false;
                }
                return super.apply(methodInfo);
            }
        });
        ProxyAspect aspectStr = new ProxyAspect(MethrefStringAdvice.class, new AllMethodsPointcut(){

            public boolean apply(MethodInfo methodInfo) {
                if (!methodInfo.getReturnType().equals(String.class.getName())) {
                    return false;
                }
                return super.apply(methodInfo);
            }
        });
        this.proxetta = ProxyProxetta.withAspects(aspectAll, aspectStr);
        this.proxetta.setClassNameSuffix(METHREF_CLASSNAME_SUFFIX);
    }

    public Class defineProxy(Class target) {
        ProxyProxettaBuilder builder = this.proxetta.builder();
        builder.setTarget(target);
        return builder.define();
    }
}

