/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import jodd.proxetta.ProxettaException;
import jodd.proxetta.ProxyAdvice;
import jodd.proxetta.asm.MethodSignatureVisitor;
import jodd.util.StringBand;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxettaAsmUtil {
    public static final String INIT = "<init>";
    public static final String CLINIT = "<clinit>";
    public static final String DESC_VOID = "()V";

    public static void pushInt(MethodVisitor mv, int value) {
        if (value <= 5) {
            mv.visitInsn(3 + value);
        } else if (value <= 127) {
            mv.visitIntInsn(16, value);
        } else {
            mv.visitIntInsn(17, value);
        }
    }

    public static int makePrivateFinalAccess(int access) {
        return access & 0xFFFFFFF0 | 2 | 0x10;
    }

    public static void checkArgumentIndex(MethodSignatureVisitor msign, int argIndex, Class<? extends ProxyAdvice> advice) {
        if (argIndex < 1 || argIndex > msign.getArgumentsCount()) {
            throw new ProxettaException("Invalid argument index: '" + argIndex + "' used in advice: " + advice.getName());
        }
    }

    public static String adviceFieldName(String name, int index) {
        return "$__" + name + "$" + index;
    }

    public static String adviceMethodName(String name, int index) {
        return "$__" + name + "$" + index;
    }

    public static void loadMethodArgumentClass(MethodVisitor mv, MethodSignatureVisitor msign, int index) {
        ProxettaAsmUtil.loadClass(mv, msign.getArgumentOpcodeType(index), msign.getArgumentTypeName(index));
    }

    public static void loadMethodReturnClass(MethodVisitor mv, MethodSignatureVisitor msign) {
        ProxettaAsmUtil.loadClass(mv, msign.getReturnOpcodeType(), msign.getReturnTypeName());
    }

    public static void loadClass(MethodVisitor mv, int type, String typeName) {
        switch (type) {
            case 86: {
                mv.visitFieldInsn(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 66: {
                mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 67: {
                mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 83: {
                mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 73: {
                mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 90: {
                mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 74: {
                mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 70: {
                mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 68: {
                mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
                break;
            }
            default: {
                mv.visitLdcInsn((Object)Type.getType((String)typeName));
            }
        }
    }

    public static void loadSpecialMethodArguments(MethodVisitor mv, MethodSignatureVisitor msign) {
        mv.visitVarInsn(25, 0);
        for (int i = 1; i <= msign.getArgumentsCount(); ++i) {
            ProxettaAsmUtil.loadMethodArgument(mv, msign, i);
        }
    }

    public static void loadVirtualMethodArguments(MethodVisitor mv, MethodSignatureVisitor msign) {
        for (int i = 1; i <= msign.getArgumentsCount(); ++i) {
            ProxettaAsmUtil.loadMethodArgument(mv, msign, i);
        }
    }

    public static void loadMethodArgument(MethodVisitor mv, MethodSignatureVisitor msign, int index) {
        int offset = msign.getArgumentOffset(index);
        char type = msign.getArgumentOpcodeType(index);
        switch (type) {
            case 'V': {
                break;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                mv.visitVarInsn(21, offset);
                break;
            }
            case 'J': {
                mv.visitVarInsn(22, offset);
                break;
            }
            case 'F': {
                mv.visitVarInsn(23, offset);
                break;
            }
            case 'D': {
                mv.visitVarInsn(24, offset);
                break;
            }
            default: {
                mv.visitVarInsn(25, offset);
            }
        }
    }

    public static void loadMethodArgumentAsObject(MethodVisitor mv, MethodSignatureVisitor msign, int index) {
        int offset = msign.getArgumentOffset(index);
        char type = msign.getArgumentOpcodeType(index);
        switch (type) {
            case 'V': {
                break;
            }
            case 'B': {
                mv.visitTypeInsn(187, "java/lang/Byte");
                mv.visitInsn(89);
                mv.visitVarInsn(21, offset);
                mv.visitMethodInsn(183, "java/lang/Byte", INIT, "(B)V");
                break;
            }
            case 'C': {
                mv.visitTypeInsn(187, "java/lang/Character");
                mv.visitInsn(89);
                mv.visitVarInsn(21, offset);
                mv.visitMethodInsn(183, "java/lang/Character", INIT, "(C)V");
                break;
            }
            case 'S': {
                mv.visitTypeInsn(187, "java/lang/Short");
                mv.visitInsn(89);
                mv.visitVarInsn(21, offset);
                mv.visitMethodInsn(183, "java/lang/Short", INIT, "(S)V");
                break;
            }
            case 'I': {
                mv.visitTypeInsn(187, "java/lang/Integer");
                mv.visitInsn(89);
                mv.visitVarInsn(21, offset);
                mv.visitMethodInsn(183, "java/lang/Integer", INIT, "(I)V");
                break;
            }
            case 'Z': {
                mv.visitVarInsn(21, offset);
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                break;
            }
            case 'J': {
                mv.visitTypeInsn(187, "java/lang/Long");
                mv.visitInsn(89);
                mv.visitVarInsn(22, offset);
                mv.visitMethodInsn(183, "java/lang/Long", INIT, "(J)V");
                break;
            }
            case 'F': {
                mv.visitTypeInsn(187, "java/lang/Float");
                mv.visitInsn(89);
                mv.visitVarInsn(23, offset);
                mv.visitMethodInsn(183, "java/lang/Float", INIT, "(F)V");
                break;
            }
            case 'D': {
                mv.visitTypeInsn(187, "java/lang/Double");
                mv.visitInsn(89);
                mv.visitVarInsn(24, offset);
                mv.visitMethodInsn(183, "java/lang/Double", INIT, "(D)V");
                break;
            }
            default: {
                mv.visitVarInsn(25, offset);
            }
        }
    }

    public static void storeMethodArgument(MethodVisitor mv, MethodSignatureVisitor msign, int index) {
        int offset = msign.getArgumentOffset(index);
        char type = msign.getArgumentOpcodeType(index);
        switch (type) {
            case 'V': {
                break;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                mv.visitVarInsn(54, offset);
                break;
            }
            case 'J': {
                mv.visitVarInsn(55, offset);
                break;
            }
            case 'F': {
                mv.visitVarInsn(56, offset);
                break;
            }
            case 'D': {
                mv.visitVarInsn(57, offset);
                break;
            }
            default: {
                mv.visitVarInsn(58, offset);
            }
        }
    }

    public static boolean isStoreOpcode(int opcode) {
        return opcode == 54 || opcode == 55 || opcode == 56 || opcode == 57 || opcode == 58;
    }

    public static void storeMethodArgumentFromObject(MethodVisitor mv, MethodSignatureVisitor msign, int index) {
        char type = msign.getArgumentOpcodeType(index);
        int offset = msign.getArgumentOffset(index);
        ProxettaAsmUtil.storeValue(mv, offset, type);
    }

    public static void storeValue(MethodVisitor mv, int offset, int type) {
        switch (type) {
            case 86: {
                break;
            }
            case 66: {
                mv.visitTypeInsn(192, "java/lang/Byte");
                mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "byteValue()B");
                mv.visitVarInsn(54, offset);
                break;
            }
            case 67: {
                mv.visitTypeInsn(192, "java/lang/Character");
                mv.visitMethodInsn(182, "java/lang/Character", "charValue", "charValue()C");
                mv.visitVarInsn(54, offset);
                break;
            }
            case 83: {
                mv.visitTypeInsn(192, "java/lang/Short");
                mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "shortValue()S");
                mv.visitVarInsn(54, offset);
                break;
            }
            case 73: {
                mv.visitTypeInsn(192, "java/lang/Integer");
                mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "intValue()I");
                mv.visitVarInsn(54, offset);
                break;
            }
            case 90: {
                mv.visitTypeInsn(192, "java/lang/Boolean");
                mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "booleanValue()Z");
                mv.visitVarInsn(54, offset);
                break;
            }
            case 74: {
                mv.visitTypeInsn(192, "java/lang/Long");
                mv.visitMethodInsn(182, "java/lang/Long", "longValue", "longValue()J");
                mv.visitVarInsn(55, offset);
                break;
            }
            case 70: {
                mv.visitTypeInsn(192, "java/lang/Float");
                mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "floatValue()F");
                mv.visitVarInsn(56, offset);
                break;
            }
            case 68: {
                mv.visitTypeInsn(192, "java/lang/Double");
                mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "doubleValue()D");
                mv.visitVarInsn(57, offset);
                break;
            }
            default: {
                mv.visitVarInsn(58, offset);
            }
        }
    }

    public static void visitReturn(MethodVisitor mv, MethodSignatureVisitor msign, boolean isLast) {
        ProxettaAsmUtil.visitReturn(mv, msign, isLast, false);
    }

    public static void visitReturn(MethodVisitor mv, MethodSignatureVisitor msign, boolean isLast, boolean returnDefault) {
        switch (msign.getReturnOpcodeType()) {
            case 'V': {
                if (isLast) {
                    mv.visitInsn(87);
                }
                mv.visitInsn(177);
                break;
            }
            case 'B': {
                if (isLast) {
                    if (returnDefault) {
                        mv.visitInsn(87);
                        mv.visitInsn(3);
                    } else {
                        mv.visitTypeInsn(192, "java/lang/Byte");
                        mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                    }
                }
                mv.visitInsn(172);
                break;
            }
            case 'C': {
                if (isLast) {
                    if (returnDefault) {
                        mv.visitInsn(87);
                        mv.visitInsn(3);
                    } else {
                        mv.visitTypeInsn(192, "java/lang/Character");
                        mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                    }
                }
                mv.visitInsn(172);
                break;
            }
            case 'S': {
                if (isLast) {
                    if (returnDefault) {
                        mv.visitInsn(87);
                        mv.visitInsn(3);
                    } else {
                        mv.visitTypeInsn(192, "java/lang/Short");
                        mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                    }
                }
                mv.visitInsn(172);
                break;
            }
            case 'I': {
                if (isLast) {
                    if (returnDefault) {
                        mv.visitInsn(87);
                        mv.visitInsn(3);
                    } else {
                        mv.visitTypeInsn(192, "java/lang/Integer");
                        mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                    }
                }
                mv.visitInsn(172);
                break;
            }
            case 'Z': {
                if (isLast) {
                    if (returnDefault) {
                        mv.visitInsn(87);
                        mv.visitInsn(3);
                    } else {
                        mv.visitTypeInsn(192, "java/lang/Boolean");
                        mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                    }
                }
                mv.visitInsn(172);
                break;
            }
            case 'J': {
                if (isLast) {
                    if (returnDefault) {
                        mv.visitInsn(87);
                        mv.visitInsn(9);
                    } else {
                        mv.visitTypeInsn(192, "java/lang/Long");
                        mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                    }
                }
                mv.visitInsn(173);
                break;
            }
            case 'F': {
                if (isLast) {
                    if (returnDefault) {
                        mv.visitInsn(87);
                        mv.visitInsn(11);
                    } else {
                        mv.visitTypeInsn(192, "java/lang/Float");
                        mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                    }
                }
                mv.visitInsn(174);
                break;
            }
            case 'D': {
                if (isLast) {
                    if (returnDefault) {
                        mv.visitInsn(87);
                        mv.visitInsn(14);
                    } else {
                        mv.visitTypeInsn(192, "java/lang/Double");
                        mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                    }
                }
                mv.visitInsn(175);
                break;
            }
            default: {
                mv.visitInsn(176);
            }
        }
    }

    public static void prepareReturnValue(MethodVisitor mv, MethodSignatureVisitor msign, int varOffset) {
        varOffset += msign.getAllArgumentsSize();
        switch (msign.getReturnOpcodeType()) {
            case 'V': {
                mv.visitInsn(1);
                break;
            }
            case 'B': {
                mv.visitVarInsn(54, varOffset);
                mv.visitTypeInsn(187, "java/lang/Byte");
                mv.visitInsn(89);
                mv.visitVarInsn(21, varOffset);
                mv.visitMethodInsn(183, "java/lang/Byte", INIT, "(B)V");
                break;
            }
            case 'C': {
                mv.visitVarInsn(54, varOffset);
                mv.visitTypeInsn(187, "java/lang/Character");
                mv.visitInsn(89);
                mv.visitVarInsn(21, varOffset);
                mv.visitMethodInsn(183, "java/lang/Character", INIT, "(C)V");
                break;
            }
            case 'S': {
                mv.visitVarInsn(54, varOffset);
                mv.visitTypeInsn(187, "java/lang/Short");
                mv.visitInsn(89);
                mv.visitVarInsn(21, varOffset);
                mv.visitMethodInsn(183, "java/lang/Short", INIT, "(S)V");
                break;
            }
            case 'I': {
                mv.visitVarInsn(54, varOffset);
                mv.visitTypeInsn(187, "java/lang/Integer");
                mv.visitInsn(89);
                mv.visitVarInsn(21, varOffset);
                mv.visitMethodInsn(183, "java/lang/Integer", INIT, "(I)V");
                break;
            }
            case 'Z': {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                break;
            }
            case 'J': {
                mv.visitVarInsn(55, varOffset);
                mv.visitTypeInsn(187, "java/lang/Long");
                mv.visitInsn(89);
                mv.visitVarInsn(22, varOffset);
                mv.visitMethodInsn(183, "java/lang/Long", INIT, "(J)V");
                break;
            }
            case 'F': {
                mv.visitVarInsn(56, varOffset);
                mv.visitTypeInsn(187, "java/lang/Float");
                mv.visitInsn(89);
                mv.visitVarInsn(23, varOffset);
                mv.visitMethodInsn(183, "java/lang/Float", INIT, "(F)V");
                break;
            }
            case 'D': {
                mv.visitVarInsn(57, varOffset);
                mv.visitTypeInsn(187, "java/lang/Double");
                mv.visitInsn(89);
                mv.visitVarInsn(24, varOffset);
                mv.visitMethodInsn(183, "java/lang/Double", INIT, "(D)V");
            }
        }
    }

    public static String createMethodSignaturesKey(int access, String methodName, String description, String className) {
        return new StringBand(7).append(access).append(":").append(description).append("_").append(className).append("#").append(methodName).toString();
    }

    public static boolean isInvokeMethod(String name, String desc) {
        return name.equals("invoke") && desc.equals("()Ljava/lang/Object;");
    }

    public static boolean isArgumentsCountMethod(String name, String desc) {
        return name.equals("argumentsCount") && desc.equals("()I");
    }

    public static boolean isArgumentTypeMethod(String name, String desc) {
        return name.equals("argumentType") && desc.equals("(I)Ljava/lang/Class;");
    }

    public static boolean isArgumentMethod(String name, String desc) {
        return name.equals("argument") && desc.equals("(I)Ljava/lang/Object;");
    }

    public static boolean isSetArgumentMethod(String name, String desc) {
        return name.equals("setArgument") && desc.equals("(Ljava/lang/Object;I)V");
    }

    public static boolean isCreateArgumentsArrayMethod(String name, String desc) {
        return name.equals("createArgumentsArray") && desc.equals("()[Ljava/lang/Object;");
    }

    public static boolean isCreateArgumentsClassArrayMethod(String name, String desc) {
        return name.equals("createArgumentsClassArray") && desc.equals("()[Ljava/lang/Class;");
    }

    public static boolean isReturnTypeMethod(String name, String desc) {
        return name.equals("returnType") && desc.equals("()Ljava/lang/Class;");
    }

    public static boolean isTargetMethod(String name, String desc) {
        return name.equals("target") && desc.equals("()Ljava/lang/Object;");
    }

    public static boolean isTargetClassMethod(String name, String desc) {
        return name.equals("targetClass") && desc.equals("()Ljava/lang/Class;");
    }

    public static boolean isTargetMethodNameMethod(String name, String desc) {
        return name.equals("targetMethodName") && desc.equals("()Ljava/lang/String;");
    }

    public static boolean isTargetMethodSignatureMethod(String name, String desc) {
        return name.equals("targetMethodSignature") && desc.equals("()Ljava/lang/String;");
    }

    public static boolean isTargetMethodDescriptionMethod(String name, String desc) {
        return name.equals("targetMethodDescription") && desc.equals("()Ljava/lang/String;");
    }

    public static boolean isPushDefaultResultValueMethod(String name, String desc) {
        return name.equals("pushDefaultResultValue") && desc.equals(DESC_VOID);
    }
}

