/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import jodd.proxetta.ProxettaException;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;

abstract class IntArgHistoryMethodAdapter
extends MethodAdapter {
    protected int opcode;
    protected int operand;
    protected boolean isPrevious;
    protected boolean traceNext;

    protected IntArgHistoryMethodAdapter(MethodVisitor methodVisitor) {
        super(methodVisitor);
    }

    protected int getArgumentIndex() {
        int argIndex;
        if (!this.isPrevious) {
            throw new ProxettaException("Unexpected previous instruction type used for setting argument index.");
        }
        switch (this.opcode) {
            case 3: {
                argIndex = 0;
                break;
            }
            case 4: {
                argIndex = 1;
                break;
            }
            case 5: {
                argIndex = 2;
                break;
            }
            case 6: {
                argIndex = 3;
                break;
            }
            case 7: {
                argIndex = 4;
                break;
            }
            case 8: {
                argIndex = 5;
                break;
            }
            case 16: 
            case 17: {
                argIndex = this.operand;
                break;
            }
            default: {
                throw new ProxettaException("Unexpected previous instruction used for setting argument index.");
            }
        }
        return argIndex;
    }

    public void visitInsn(int opcode) {
        this.opcode = opcode;
        this.isPrevious = true;
        this.traceNext = false;
        super.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.opcode = opcode;
        this.operand = operand;
        this.isPrevious = true;
        this.traceNext = false;
        super.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int i, int i1) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitVarInsn(i, i1);
    }

    public void visitTypeInsn(int i, String string) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitTypeInsn(i, string);
    }

    public void visitFieldInsn(int i, String string, String string1, String string2) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitFieldInsn(i, string, string1, string2);
    }

    public void visitMethodInsn(int i, String string, String string1, String string2) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitMethodInsn(i, string, string1, string2);
    }

    public void visitJumpInsn(int i, Label label) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitJumpInsn(i, label);
    }

    public void visitLdcInsn(Object object) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitLdcInsn(object);
    }

    public void visitIincInsn(int i, int i1) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitIincInsn(i, i1);
    }

    public void visitTableSwitchInsn(int i, int i1, Label label, Label[] labels) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitTableSwitchInsn(i, i1, label, labels);
    }

    public void visitLookupSwitchInsn(Label label, int[] ints, Label[] labels) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitLookupSwitchInsn(label, ints, labels);
    }

    public void visitMultiANewArrayInsn(String string, int i) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitMultiANewArrayInsn(string, i);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
    }

    public void visitLineNumber(int i, Label label) {
    }
}

