/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.petite.InitMethodPoint;
import jodd.petite.PetiteException;
import jodd.petite.meta.PetiteInitMethod;

public class InitMethodResolver {
    protected final Map<Class, InitMethodPoint[]> initMethods = new HashMap<Class, InitMethodPoint[]>();

    public InitMethodPoint[] resolve(Object bean) {
        Method[] allMethods;
        Class<?> type = bean.getClass();
        InitMethodPoint[] methods = this.initMethods.get(type);
        if (methods != null) {
            return methods;
        }
        ArrayList<InitMethodPoint> list = new ArrayList<InitMethodPoint>();
        ClassDescriptor cd = new ClassDescriptor(type, false);
        for (Method method : allMethods = cd.getAllMethods(true)) {
            PetiteInitMethod petiteInitMethod = method.getAnnotation(PetiteInitMethod.class);
            if (petiteInitMethod == null) continue;
            if (method.getParameterTypes().length > 0) {
                throw new PetiteException("Arguments are not allowed for Petite init method: " + type.getName() + '#' + method.getName() + "().");
            }
            int order = petiteInitMethod.order();
            list.add(new InitMethodPoint(method, order, petiteInitMethod.firstOff()));
        }
        if (list.isEmpty()) {
            methods = InitMethodPoint.EMPTY;
        } else {
            Collections.sort(list);
            methods = list.toArray(new InitMethodPoint[list.size()]);
        }
        this.initMethods.put(type, methods);
        return methods;
    }

    public void remove(Class type) {
        this.initMethods.remove(type);
    }
}

