/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.htmlstapler;

import jodd.lagarto.Tag;
import jodd.lagarto.TagAdapter;
import jodd.lagarto.TagVisitor;
import jodd.lagarto.htmlstapler.BundleAction;
import jodd.lagarto.htmlstapler.HtmlStaplerBundlesManager;

public class HtmlStaplerTagAdapter
extends TagAdapter {
    protected final HtmlStaplerBundlesManager bundlesManager;
    protected final BundleAction jsBundleAction;
    protected final BundleAction cssBundleAction;
    protected boolean insideConditionalComment;

    public HtmlStaplerTagAdapter(HtmlStaplerBundlesManager bundlesManager, String servletPath, TagVisitor target) {
        super(target);
        this.bundlesManager = bundlesManager;
        this.jsBundleAction = bundlesManager.start(servletPath, "js");
        this.cssBundleAction = bundlesManager.start(servletPath, "css");
        this.insideConditionalComment = false;
    }

    public void script(Tag tag, CharSequence body) {
        String src;
        if (!this.insideConditionalComment && this.jsBundleAction.acceptLink(src = tag.getAttributeValue("src", false))) {
            String link = this.jsBundleAction.processLink(src);
            if (link != null) {
                tag.setAttributeValue("src", false, link);
                super.script(tag, body);
            }
            return;
        }
        super.script(tag, body);
    }

    public void tag(Tag tag) {
        String href;
        String media;
        String type;
        if (!this.insideConditionalComment && tag.getName().equalsIgnoreCase("link") && (type = tag.getAttributeValue("type", false)) != null && type.equalsIgnoreCase("text/css") && ((media = tag.getAttributeValue("media", false)) == null || media.contains("screen")) && this.cssBundleAction.acceptLink(href = tag.getAttributeValue("href", false))) {
            String link = this.cssBundleAction.processLink(href);
            if (link != null) {
                tag.setAttribute("href", false, link);
                super.tag(tag);
            }
            return;
        }
        super.tag(tag);
    }

    public void condComment(CharSequence expression, boolean isStartingTag, boolean isHidden, CharSequence comment) {
        this.insideConditionalComment = isStartingTag;
        super.condComment(expression, isStartingTag, isHidden, comment);
    }

    public void end() {
        this.jsBundleAction.end();
        this.cssBundleAction.end();
        super.end();
    }

    public char[] postProcess(char[] content) {
        content = this.jsBundleAction.replaceBundleId(content);
        content = this.cssBundleAction.replaceBundleId(content);
        return content;
    }
}

