/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jodd.asm.EmptyClassVisitor;
import jodd.asm.EmptyMethodVisitor;
import jodd.io.StreamUtil;
import jodd.proxetta.AnnotationInfo;
import jodd.proxetta.ClassInfo;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.asm.AnnotationReader;
import jodd.proxetta.asm.MethodSignatureVisitor;
import jodd.proxetta.asm.ProxettaAsmUtil;
import jodd.util.ClassLoaderUtil;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class TargetClassInfoReader
extends EmptyClassVisitor
implements ClassInfo {
    protected final Map<String, MethodSignatureVisitor> methodSignatures = new HashMap<String, MethodSignatureVisitor>();
    protected final List<ClassReader> superClassReaders = new ArrayList<ClassReader>();
    protected final Set<String> allMethodSignatures = new HashSet<String>();
    protected String targetPackage;
    protected String targetClassname;
    protected String superName;
    protected String thisReference;
    protected String nextSupername;
    protected String[] superClasses;
    protected int hierarchyLevel;
    protected AnnotationInfo[] annotations;
    protected List<AnnotationInfo> classAnnotations;

    public MethodSignatureVisitor lookupMethodSignatureVisitor(int access, String name, String desc, String className) {
        String key = ProxettaAsmUtil.createMethodSignaturesKey(access, name, desc, className);
        return this.methodSignatures.get(key);
    }

    public boolean isMarkedForProxy(MethodSignatureVisitor msgin) {
        return this.allMethodSignatures.contains(msgin.getSignature());
    }

    public String getPackage() {
        return this.targetPackage;
    }

    public String getClassname() {
        return this.targetClassname;
    }

    public String getSuperName() {
        return this.superName;
    }

    public String getReference() {
        return this.thisReference;
    }

    public String[] getSuperClasses() {
        return this.superClasses;
    }

    public AnnotationInfo[] getAnnotations() {
        return this.annotations;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        int lastSlash = name.lastIndexOf(47);
        this.thisReference = name;
        this.superName = superName;
        this.nextSupername = superName;
        this.targetPackage = name.substring(0, lastSlash).replace('/', '.');
        this.targetClassname = name.substring(lastSlash + 1);
        this.hierarchyLevel = 1;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationReader ar = new AnnotationReader(desc, visible);
        if (this.classAnnotations == null) {
            this.classAnnotations = new ArrayList<AnnotationInfo>();
        }
        this.classAnnotations.add(ar);
        return ar;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x10) != 0) {
            return null;
        }
        MethodSignatureVisitor msign = this.createMethodSignature(access, name, desc, this.thisReference);
        String key = ProxettaAsmUtil.createMethodSignaturesKey(access, name, desc, this.thisReference);
        this.methodSignatures.put(key, msign);
        this.allMethodSignatures.add(msign.getSignature());
        return new MethodAnnotationReader(msign);
    }

    public void visitEnd() {
        if (this.classAnnotations != null) {
            this.annotations = this.classAnnotations.toArray(new AnnotationInfo[this.classAnnotations.size()]);
            this.classAnnotations = null;
        }
        ArrayList<String> superList = new ArrayList<String>();
        while (this.nextSupername != null) {
            InputStream inputStream = null;
            ClassReader cr = null;
            try {
                inputStream = ClassLoaderUtil.getClassAsStream((String)this.nextSupername);
                cr = new ClassReader(inputStream);
            }
            catch (IOException ioex) {
                throw new ProxettaException("Unable to inspect super class: " + this.nextSupername, ioex);
            }
            finally {
                StreamUtil.close((InputStream)inputStream);
            }
            ++this.hierarchyLevel;
            superList.add(this.nextSupername);
            this.superClassReaders.add(cr);
            cr.accept((ClassVisitor)new EmptyClassVisitor(){
                String declaredClassName;

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    TargetClassInfoReader.this.nextSupername = superName;
                    this.declaredClassName = name;
                }

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    if (name.equals("<init>") || name.equals("<clinit>")) {
                        return null;
                    }
                    MethodSignatureVisitor msign = TargetClassInfoReader.this.createMethodSignature(access, name, desc, TargetClassInfoReader.this.thisReference);
                    int acc = msign.getAccessFlags();
                    if ((acc & 1) == 0) {
                        return null;
                    }
                    if ((access & 0x10) != 0) {
                        return null;
                    }
                    if (TargetClassInfoReader.this.allMethodSignatures.contains(msign.getSignature())) {
                        return null;
                    }
                    msign.setDeclaredClassName(this.declaredClassName);
                    String key = ProxettaAsmUtil.createMethodSignaturesKey(access, name, desc, this.declaredClassName);
                    TargetClassInfoReader.this.methodSignatures.put(key, msign);
                    TargetClassInfoReader.this.allMethodSignatures.add(msign.getSignature());
                    return new MethodAnnotationReader(msign);
                }
            }, 0);
        }
        this.superClasses = superList.toArray(new String[superList.size()]);
    }

    protected MethodSignatureVisitor createMethodSignature(int access, String methodName, String description, String classname) {
        MethodSignatureVisitor v = new MethodSignatureVisitor(methodName, access, classname, description, this);
        v.hierarchyLevel = this.hierarchyLevel;
        new SignatureReader(description).accept((SignatureVisitor)v);
        return v;
    }

    static class MethodAnnotationReader
    extends EmptyMethodVisitor {
        final List<AnnotationInfo> methodAnns = new ArrayList<AnnotationInfo>();
        final MethodSignatureVisitor msign;

        MethodAnnotationReader(MethodSignatureVisitor msign) {
            this.msign = msign;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationReader ar = new AnnotationReader(desc, visible);
            this.methodAnns.add(ar);
            return ar;
        }

        public void visitEnd() {
            if (!this.methodAnns.isEmpty()) {
                this.msign.annotations = this.methodAnns.toArray(new AnnotationInfo[this.methodAnns.size()]);
            }
        }
    }
}

