/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.util.HashMap;
import java.util.Map;
import jodd.madvoc.MadvocException;
import jodd.madvoc.result.ActionResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultsManager {
    protected final Map<String, ActionResult> results = new HashMap<String, ActionResult>();

    public Map<String, ActionResult> getAllActionResults() {
        return this.results;
    }

    public ActionResult register(Class<? extends ActionResult> resultClass) {
        ActionResult result = this.createResult(resultClass);
        ActionResult existing = this.lookup(result.getType());
        if (existing != null) {
            if (!existing.getClass().equals(resultClass)) {
                throw new MadvocException("Madvoc result with the same result type '" + result.getType() + "' already registered: '" + resultClass.getSimpleName() + "'.");
            }
            result = existing;
        } else {
            this.results.put(result.getType(), result);
        }
        return result;
    }

    public ActionResult lookup(String resultType) {
        return this.results.get(resultType);
    }

    protected ActionResult createResult(Class<? extends ActionResult> actionResultClass) {
        try {
            return actionResultClass.newInstance();
        }
        catch (InstantiationException iex) {
            throw new MadvocException("Unable to create Madvoc action result: " + actionResultClass, iex);
        }
        catch (IllegalAccessException iaex) {
            throw new MadvocException("Not enough rights to create Madvoc action result: " + actionResultClass, iaex);
        }
    }
}

