/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.connection;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import jodd.db.DbSqlException;
import jodd.db.connection.ConnectionProvider;

public class ConnectionPoolDataSourceConnectionProvider
implements ConnectionProvider {
    private ConnectionPoolDataSource cpds;

    public ConnectionPoolDataSourceConnectionProvider(ConnectionPoolDataSource cpds) {
        this.cpds = cpds;
    }

    public void init() {
    }

    public void close() {
        this.cpds = null;
    }

    public Connection getConnection() {
        PooledConnection pconn;
        try {
            pconn = this.cpds.getPooledConnection();
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to get pooled connection.", sex);
        }
        try {
            return pconn.getConnection();
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to get connection from pooled connection.", sex);
        }
    }

    public void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

